/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.filter;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class CommonTableCursor
extends TableCursor {
    protected TableViewer tableViewer;

    public CommonTableCursor(TableViewer tableViewer) {
        super(tableViewer.getTable(), 0);
        this.tableViewer = tableViewer;
        this.setBackground(Display.getDefault().getSystemColor(26));
        this.setForeground(Display.getDefault().getSystemColor(27));
        this.registerCellEditorsListener();
        this.registerKeyListener();
        this.registerMouseListener();
        this.registerTraverseListener();
        this.addListeners();
    }

    protected void registerTraverseListener() {
        this.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                CommonTableCursor.this.handleTraverse(e);
            }
        });
    }

    protected void registerMouseListener() {
        this.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (e.button == 1) {
                    CommonTableCursor.this.edit();
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }

    protected void registerKeyListener() {
        this.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character != '\u0000' && e.character != '\r' && e.character != '\n' && e.character != '\b' && e.character != '\u007f' && e.character != '\t' && e.character != '\u001b' && (e.stateMask == 0 || e.stateMask == 131072)) {
                    CommonTableCursor.this.edit();
                    CellEditor editor = CommonTableCursor.this.tableViewer.getCellEditors()[CommonTableCursor.this.getColumn()];
                    if (editor instanceof TextCellEditor) {
                        editor.setValue((Object)String.valueOf(e.character));
                        ((Text)editor.getControl()).setSelection(1);
                    }
                } else if (e.keyCode == 0x100000B) {
                    CommonTableCursor.this.edit();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
    }

    protected void registerCellEditorsListener() {
        ICellEditorListener editorListener = new ICellEditorListener(){

            public void applyEditorValue() {
                CommonTableCursor.this.setVisible(true);
                CommonTableCursor.this.redraw();
            }

            public void cancelEditor() {
                CommonTableCursor.this.setVisible(true);
            }

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            }
        };
        CellEditor[] editors = this.tableViewer.getCellEditors();
        if (editors == null) {
            return;
        }
        int i = 0;
        while (i < editors.length) {
            if (editors[i] != null) {
                editors[i].addListener(editorListener);
            }
            ++i;
        }
    }

    public void edit() {
        Object o = this.getRow().getData();
        this.tableViewer.editElement(o, this.getColumn());
    }

    protected void handleTraverse(TraverseEvent event) {
        if (event.widget == this) {
            return;
        }
        int row = this.getRow() == null ? 0 : this.tableViewer.getTable().indexOf(this.getRow());
        int col = this.getColumn();
        switch (event.detail) {
            case 8: {
                if (col != 0) {
                    --col;
                } else if (row != 0) {
                    col = this.tableViewer.getTable().getColumnCount() - 1;
                    --row;
                } else {
                    return;
                }
                this.setSelection(row, col);
                event.doit = false;
                return;
            }
            case 16: {
                if (col != this.tableViewer.getTable().getColumnCount() - 1) {
                    ++col;
                } else if (row != this.tableViewer.getTable().getItemCount() - 1) {
                    col = 0;
                    ++row;
                } else {
                    return;
                }
                this.setSelection(row, col);
                event.doit = false;
                return;
            }
        }
    }

    protected void addListeners() {
        this.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommonTableCursor.this.tableViewer.setSelection((ISelection)new StructuredSelection(CommonTableCursor.this.tableViewer.getElementAt(CommonTableCursor.this.tableViewer.getTable().indexOf(CommonTableCursor.this.getRow()))));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                int column = CommonTableCursor.this.getColumn();
                IStructuredSelection selection = (IStructuredSelection)CommonTableCursor.this.tableViewer.getSelection();
                if (!selection.isEmpty()) {
                    CommonTableCursor.this.tableViewer.editElement(selection.getFirstElement(), column);
                }
            }
        });
        this.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 262144 || e.keyCode == 131072 || (e.stateMask & 0x40000) != 0 || (e.stateMask & 0x20000) != 0) {
                    CommonTableCursor.this.setVisible(false);
                }
            }
        });
        this.tableViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 262144 && (e.stateMask & 0x20000) != 0) {
                    return;
                }
                if (e.keyCode == 131072 && (e.stateMask & 0x40000) != 0) {
                    return;
                }
                if (e.keyCode != 262144 && (e.stateMask & 0x40000) != 0) {
                    return;
                }
                if (e.keyCode != 131072 && (e.stateMask & 0x20000) != 0) {
                    return;
                }
                Table table = CommonTableCursor.this.tableViewer.getTable();
                TableItem[] selection = table.getSelection();
                if (table.getItemCount() > 0) {
                    TableItem row = selection.length == 0 ? table.getItem(table.getTopIndex()) : selection[0];
                    table.showItem(row);
                    CommonTableCursor.this.setSelection(row, CommonTableCursor.this.getColumn());
                    CommonTableCursor.this.setVisible(true);
                    CommonTableCursor.this.setFocus();
                }
            }
        });
    }
}

