/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.remote;

import org.eclipse.jem.internal.proxy.common.remote.Commands;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IIntegerBeanProxy;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.internal.proxy.remote.REMIntegerTypeBeanProxy;
import org.eclipse.jem.internal.proxy.remote.REMPrimitiveBeanTypeProxy;
import org.eclipse.jem.internal.proxy.remote.REMProxyFactoryRegistry;

final class REMIntegerTypeBeanTypeProxy
extends REMPrimitiveBeanTypeProxy {
    private final IIntegerBeanProxy zeroProxy;
    private final IIntegerBeanProxy oneProxy;
    private final IIntegerBeanProxy twoProxy;
    private final IIntegerBeanProxy threeProxy;

    REMIntegerTypeBeanTypeProxy(REMProxyFactoryRegistry aRegistry) {
        super(aRegistry, new Integer(3), Integer.TYPE.getName());
        this.zeroProxy = new REMIntegerTypeBeanProxy(aRegistry, 0);
        this.oneProxy = new REMIntegerTypeBeanProxy(aRegistry, 1);
        this.twoProxy = new REMIntegerTypeBeanProxy(aRegistry, 2);
        this.threeProxy = new REMIntegerTypeBeanProxy(aRegistry, 3);
    }

    IIntegerBeanProxy createIntegerBeanProxy(int anInt) {
        switch (anInt) {
            case 0: {
                return this.zeroProxy;
            }
            case 1: {
                return this.oneProxy;
            }
            case 2: {
                return this.twoProxy;
            }
            case 3: {
                return this.threeProxy;
            }
        }
        return new REMIntegerTypeBeanProxy(this.fRegistry, anInt);
    }

    @Override
    public IBeanProxy newInstance() {
        return this.zeroProxy;
    }

    @Override
    public IBeanProxy newBeanProxy(Commands.ValueObject value) {
        return this.createIntegerBeanProxy(value.anInt);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public IBeanProxy newInstance(String initializationString) throws ThrowableProxy, ClassCastException, InstantiationException {
        int anInt;
        String trim = initializationString.trim();
        if (trim.length() == 0) {
            return super.newInstance(initializationString);
        }
        if (trim.startsWith("(int)")) {
            Number v = REMIntegerTypeBeanTypeProxy.parseString(trim.substring("(int)".length()).trim());
            if (v == null) return super.newInstance(initializationString);
            anInt = v.intValue();
            return this.getProxyFactoryRegistry().getBeanProxyFactory().createBeanProxyWith(anInt);
        }
        try {
            anInt = Integer.decode(trim);
            return this.getProxyFactoryRegistry().getBeanProxyFactory().createBeanProxyWith(anInt);
        }
        catch (NumberFormatException numberFormatException) {
            return super.newInstance(initializationString);
        }
    }
}

