/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.preferences;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.m2m.atl.adt.ui.AtlUIPlugin;
import org.eclipse.m2m.atl.adt.ui.preferences.AtlCodeFormatterPropertyPage;
import org.eclipse.m2m.atl.adt.ui.preferences.PreferencesAccess;

public abstract class ProfileManager
extends Observable {
    public static final String ID_PREFIX = "_";
    public static final int SELECTION_CHANGED_EVENT = 1;
    public static final int PROFILE_DELETED_EVENT = 2;
    public static final int PROFILE_RENAMED_EVENT = 3;
    public static final int PROFILE_CREATED_EVENT = 4;
    public static final int SETTINGS_CHANGED_EVENT = 5;
    private final String fProfileKey;
    private static final String SHARED_PROFILE = "org.eclipse.jdt.ui.default.shared";
    private final Map<String, Profile> fProfiles;
    private final List<Profile> fProfilesByName;
    private Profile fSelected;
    private final KeySet[] fKeySets;
    private final PreferencesAccess fPreferencesAccess;

    public ProfileManager(List<Profile> profiles, IScopeContext context, PreferencesAccess preferencesAccess, KeySet[] keySets, String profileKey) {
        Profile curr;
        String projProfileId;
        Profile profile2;
        this.fPreferencesAccess = preferencesAccess;
        this.fKeySets = keySets;
        this.fProfileKey = profileKey;
        this.fProfiles = new HashMap<String, Profile>();
        this.fProfilesByName = new ArrayList<Profile>();
        for (Profile profile2 : profiles) {
            if (profile2 instanceof CustomProfile) {
                ((CustomProfile)profile2).setManager(this);
            }
            this.fProfiles.put(profile2.getID(), profile2);
            this.fProfilesByName.add(profile2);
        }
        Collections.sort(this.fProfilesByName);
        String profileId = this.getSelectedProfileId(this.fPreferencesAccess.getInstanceScope());
        profile2 = this.fProfiles.get(profileId);
        if (profile2 == null) {
            profile2 = this.getDefaultProfile();
        }
        this.fSelected = profile2;
        if (context.getName() == "project" && (projProfileId = context.getNode(AtlUIPlugin.getPluginId()).get(AtlCodeFormatterPropertyPage.CURRENT_PROFILE_KEY, null)) != null && (curr = this.fProfiles.get(projProfileId)) != null) {
            this.fSelected = curr;
        }
    }

    protected String getSelectedProfileId(IScopeContext instanceScope) {
        String profileId = instanceScope.getNode(AtlUIPlugin.getPluginId()).get(this.fProfileKey, null);
        if (profileId == null) {
            profileId = new DefaultScope().getNode(AtlUIPlugin.getPluginId()).get(this.fProfileKey, null);
        }
        return profileId;
    }

    protected void notifyObservers(int message) {
        this.setChanged();
        this.notifyObservers(new Integer(message));
    }

    public static boolean hasProjectSpecificSettings(IScopeContext context, KeySet[] keySets) {
        int i = 0;
        while (i < keySets.length) {
            KeySet keySet = keySets[i];
            IEclipsePreferences preferences = context.getNode(keySet.getNodeName());
            for (String key : keySet.getKeys()) {
                String val = preferences.get(key, null);
                if (val == null) continue;
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasProjectSpecificSettings(IScopeContext context) {
        return ProfileManager.hasProjectSpecificSettings(context, this.fKeySets);
    }

    private boolean updatePreferences(IEclipsePreferences prefs, List<String> keys, Map<String, String> profileOptions) {
        boolean hasChanges = false;
        for (String key : keys) {
            String oldVal = prefs.get(key, null);
            String val = profileOptions.get(key);
            if (val == null) {
                if (oldVal == null) continue;
                prefs.remove(key);
                hasChanges = true;
                continue;
            }
            if (val.equals(oldVal)) continue;
            prefs.put(key, val);
            hasChanges = true;
        }
        return hasChanges;
    }

    private void writeToPreferenceStore(Profile profile, IScopeContext context) {
        Map<String, String> profileOptions = profile.getSettings();
        int i = 0;
        while (i < this.fKeySets.length) {
            this.updatePreferences(context.getNode(this.fKeySets[i].getNodeName()), this.fKeySets[i].getKeys(), profileOptions);
            ++i;
        }
        IEclipsePreferences uiPrefs = context.getNode(AtlUIPlugin.getPluginId());
        if (context.getName() == "instance") {
            uiPrefs.put(this.fProfileKey, profile.getID());
        } else if (context.getName() == "project" && !profile.isSharedProfile()) {
            uiPrefs.put(this.fProfileKey, profile.getID());
        }
    }

    public List<Profile> getSortedProfiles() {
        return Collections.unmodifiableList(this.fProfilesByName);
    }

    public String[] getSortedDisplayNames() {
        String[] sortedNames = new String[this.fProfilesByName.size()];
        int i = 0;
        for (Profile curr : this.fProfilesByName) {
            sortedNames[i++] = curr.getName();
        }
        return sortedNames;
    }

    public Profile getProfile(String ID) {
        return this.fProfiles.get(ID);
    }

    public void commitChanges(IScopeContext scopeContext) {
        if (this.fSelected != null) {
            this.writeToPreferenceStore(this.fSelected, scopeContext);
        }
    }

    public void clearAllSettings(IScopeContext context) {
        int i = 0;
        while (i < this.fKeySets.length) {
            this.updatePreferences(context.getNode(this.fKeySets[i].getNodeName()), this.fKeySets[i].getKeys(), new HashMap<String, String>());
            ++i;
        }
        IEclipsePreferences uiPrefs = context.getNode(AtlUIPlugin.getPluginId());
        uiPrefs.remove(this.fProfileKey);
    }

    public Profile getSelected() {
        return this.fSelected;
    }

    public void setSelected(Profile profile) {
        Profile newSelected = this.fProfiles.get(profile.getID());
        if (newSelected != null && !newSelected.equals(this.fSelected)) {
            this.fSelected = newSelected;
            this.notifyObservers(1);
        }
    }

    public boolean containsName(String name) {
        for (Profile curr : this.fProfilesByName) {
            if (!name.equals(curr.getName())) continue;
            return true;
        }
        return false;
    }

    public void addProfile(CustomProfile profile) {
        profile.setManager(this);
        CustomProfile oldProfile = (CustomProfile)this.fProfiles.get(profile.getID());
        if (oldProfile != null) {
            this.fProfiles.remove(oldProfile.getID());
            this.fProfilesByName.remove(oldProfile);
            oldProfile.setManager(null);
        }
        this.fProfiles.put(profile.getID(), profile);
        this.fProfilesByName.add(profile);
        Collections.sort(this.fProfilesByName);
        this.fSelected = profile;
        this.notifyObservers(4);
    }

    public boolean deleteSelected() {
        if (!(this.fSelected instanceof CustomProfile)) {
            return false;
        }
        return this.deleteProfile((CustomProfile)this.fSelected);
    }

    public boolean deleteProfile(CustomProfile profile) {
        int index = this.fProfilesByName.indexOf(profile);
        this.fProfiles.remove(profile.getID());
        this.fProfilesByName.remove(profile);
        profile.setManager(null);
        if (index >= this.fProfilesByName.size()) {
            --index;
        }
        this.fSelected = this.fProfilesByName.get(index);
        if (!profile.isSharedProfile()) {
            this.updateProfilesWithName(profile.getID(), null, false);
        }
        this.notifyObservers(2);
        return true;
    }

    public void profileRenamed(CustomProfile profile, String oldID) {
        this.fProfiles.remove(oldID);
        this.fProfiles.put(profile.getID(), profile);
        if (!profile.isSharedProfile()) {
            this.updateProfilesWithName(oldID, profile, false);
        }
        Collections.sort(this.fProfilesByName);
        this.notifyObservers(3);
    }

    public void profileReplaced(CustomProfile oldProfile, CustomProfile newProfile) {
        this.fProfiles.remove(oldProfile.getID());
        this.fProfiles.put(newProfile.getID(), newProfile);
        this.fProfilesByName.remove(oldProfile);
        this.fProfilesByName.add(newProfile);
        Collections.sort(this.fProfilesByName);
        if (!oldProfile.isSharedProfile()) {
            this.updateProfilesWithName(oldProfile.getID(), null, false);
        }
        this.setSelected(newProfile);
        this.notifyObservers(4);
        this.notifyObservers(1);
    }

    public void profileChanged(CustomProfile profile) {
        if (!profile.isSharedProfile()) {
            this.updateProfilesWithName(profile.getID(), profile, true);
        }
        this.notifyObservers(5);
    }

    protected void updateProfilesWithName(String oldName, Profile newProfile, boolean applySettings) {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IScopeContext projectScope = this.fPreferencesAccess.getProjectScope(projects[i]);
            IEclipsePreferences node = projectScope.getNode(AtlUIPlugin.getPluginId());
            String profileId = node.get(this.fProfileKey, null);
            if (oldName.equals(profileId)) {
                if (newProfile == null) {
                    node.remove(this.fProfileKey);
                } else if (applySettings) {
                    this.writeToPreferenceStore(newProfile, projectScope);
                } else {
                    node.put(this.fProfileKey, newProfile.getID());
                }
            }
            ++i;
        }
        IScopeContext instanceScope = this.fPreferencesAccess.getInstanceScope();
        IEclipsePreferences uiPrefs = instanceScope.getNode(AtlUIPlugin.getPluginId());
        if (newProfile != null && oldName.equals(uiPrefs.get(this.fProfileKey, null))) {
            this.writeToPreferenceStore(newProfile, instanceScope);
        }
    }

    public abstract Profile getDefaultProfile();

    public static final class BuiltInProfile
    extends Profile {
        private final String fName;
        private final String fID;
        private final Map<String, String> fSettings;
        private final int fOrder;

        public BuiltInProfile(String ID, String name, Map<String, String> settings, int order) {
            this.fName = name;
            this.fID = ID;
            this.fSettings = settings;
            this.fOrder = order;
        }

        @Override
        public String getName() {
            return this.fName;
        }

        @Override
        public Profile rename(String name, ProfileManager manager) {
            String trimmed = name.trim();
            CustomProfile newProfile = new CustomProfile(trimmed, this.fSettings);
            manager.addProfile(newProfile);
            return newProfile;
        }

        @Override
        public Map<String, String> getSettings() {
            return this.fSettings;
        }

        @Override
        public String getID() {
            return this.fID;
        }

        @Override
        public boolean isProfileToSave() {
            return false;
        }

        @Override
        public boolean isBuiltInProfile() {
            return true;
        }

        @Override
        public int compareTo(Profile o) {
            if (o instanceof BuiltInProfile) {
                return this.fOrder - ((BuiltInProfile)o).fOrder;
            }
            return -1;
        }

        @Override
        public void setSettings(Map<String, String> settings) {
        }
    }

    public static class CustomProfile
    extends Profile {
        private String fName;
        private Map<String, String> fSettings;
        protected ProfileManager fManager;

        public CustomProfile(String name, Map<String, String> settings) {
            this.fName = name;
            this.fSettings = settings;
        }

        @Override
        public String getName() {
            return this.fName;
        }

        @Override
        public Profile rename(String name, ProfileManager manager) {
            String trimmed = name.trim();
            if (trimmed.equals(this.getName())) {
                return this;
            }
            String oldID = this.getID();
            this.fName = trimmed;
            manager.profileRenamed(this, oldID);
            return this;
        }

        @Override
        public Map<String, String> getSettings() {
            return this.fSettings;
        }

        @Override
        public void setSettings(Map<String, String> settings) {
            if (settings == null) {
                throw new IllegalArgumentException();
            }
            this.fSettings = settings;
            if (this.fManager != null) {
                this.fManager.profileChanged(this);
            }
        }

        @Override
        public String getID() {
            return ProfileManager.ID_PREFIX + this.fName;
        }

        public void setManager(ProfileManager profileManager) {
            this.fManager = profileManager;
        }

        public ProfileManager getManager() {
            return this.fManager;
        }

        @Override
        public boolean isProfileToSave() {
            return true;
        }

        @Override
        public int compareTo(Profile o) {
            if (o instanceof SharedProfile) {
                return -1;
            }
            if (o instanceof CustomProfile) {
                return this.getName().compareToIgnoreCase(o.getName());
            }
            return 1;
        }
    }

    public static final class KeySet {
        private final List<String> fKeys;
        private final String fNodeName;

        public KeySet(String nodeName, List<String> keys) {
            this.fNodeName = nodeName;
            this.fKeys = keys;
        }

        public String getNodeName() {
            return this.fNodeName;
        }

        public List<String> getKeys() {
            return this.fKeys;
        }
    }

    public static abstract class Profile
    implements Comparable<Profile> {
        public abstract String getName();

        public abstract Profile rename(String var1, ProfileManager var2);

        public abstract Map<String, String> getSettings();

        public abstract void setSettings(Map<String, String> var1);

        public boolean hasEqualSettings(Map<String, String> otherMap, Collection<String> allKeys) {
            Map<String, String> settings = this.getSettings();
            for (String key : allKeys) {
                String other = otherMap.get(key);
                String curr = settings.get(key);
                if (!(other == null ? curr != null : !other.equals(curr))) continue;
                return false;
            }
            return true;
        }

        public abstract boolean isProfileToSave();

        public abstract String getID();

        public boolean isSharedProfile() {
            return false;
        }

        public boolean isBuiltInProfile() {
            return false;
        }
    }

    public final class SharedProfile
    extends CustomProfile {
        public SharedProfile(String oldName, Map<String, String> options) {
            super(oldName, options);
        }

        @Override
        public Profile rename(String name, ProfileManager manager) {
            CustomProfile profile = new CustomProfile(name.trim(), this.getSettings());
            manager.profileReplaced(this, profile);
            return profile;
        }

        @Override
        public String getID() {
            return ProfileManager.SHARED_PROFILE;
        }

        @Override
        public final int compareTo(Profile o) {
            return 1;
        }

        @Override
        public boolean isProfileToSave() {
            return false;
        }

        @Override
        public boolean isSharedProfile() {
            return true;
        }
    }
}

