/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.tracwiki.internal.token;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.ImageAttributes;
import org.eclipse.mylyn.wikitext.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.parser.markup.PatternBasedElementProcessor;

public class MacroReplacementToken
extends PatternBasedElement {
    protected String getPattern(int groupOffset) {
        return "(?:\\[\\[([a-zA-Z]+)(?:\\(((?:(?!\\]\\]).)*)\\))?\\]\\])";
    }

    protected int getPatternGroupCount() {
        return 2;
    }

    protected PatternBasedElementProcessor newProcessor() {
        return new MacroReplacementTokenProcessor();
    }

    private static class MacroReplacementTokenProcessor
    extends PatternBasedElementProcessor {
        private MacroReplacementTokenProcessor() {
        }

        public void emit() {
            String macro = this.group(1);
            String[] args = this.group(2) != null && this.group(2).length() > 0 ? this.group(2).split(",") : new String[]{};
            if (macro.equalsIgnoreCase("Image")) {
                this.imageMacro(args);
            }
        }

        public void imageMacro(String[] args) {
            if (args.length < 1) {
                return;
            }
            Pattern borderPattern = Pattern.compile("border=([0-9]+)");
            Pattern sizePattern = Pattern.compile("(?:(width|height)=|^)?([0-9]+)(%|px)?");
            Pattern alignPattern = Pattern.compile("(?:align=)?(right|left|top|bottom)");
            ImageAttributes attributes = new ImageAttributes();
            int i = 1;
            while (i < args.length) {
                String arg = args[i].trim();
                Matcher m = borderPattern.matcher(arg);
                if (m.matches()) {
                    attributes.setBorder(Integer.parseInt(m.group(1)));
                } else {
                    m = sizePattern.matcher(arg);
                    if (m.matches()) {
                        int size = Integer.parseInt(m.group(2));
                        if (m.group(1) == null || m.group(1).length() == 0 || m.group(1).equalsIgnoreCase("width")) {
                            attributes.setWidth(size);
                            attributes.setWidthPercentage(m.group(3) != null && m.group(3).equals("%"));
                        } else {
                            attributes.setHeight(size);
                            attributes.setHeightPercentage(m.group(3) != null && m.group(3).equals("%"));
                        }
                    } else {
                        m = alignPattern.matcher(arg);
                        if (m.matches()) {
                            attributes.appendCssStyle("float:" + m.group(1) + ";");
                        } else {
                            String[] parts = arg.split("=");
                            if (parts.length == 2) {
                                if (parts[0].equalsIgnoreCase("id")) {
                                    attributes.setId(parts[1]);
                                }
                                if (parts[0].equalsIgnoreCase("class")) {
                                    attributes.appendCssClass(parts[1]);
                                }
                                if (parts[0].equalsIgnoreCase("alt")) {
                                    attributes.setAlt(parts[1]);
                                }
                                if (parts[0].equalsIgnoreCase("title")) {
                                    attributes.setTitle(parts[1]);
                                }
                            }
                        }
                    }
                }
                ++i;
            }
            this.builder.image((Attributes)attributes, args[0]);
        }
    }
}

