/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.refresh;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.refresh.RefreshRunnableWithProgress;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.ui.business.api.action.RefreshActionListenerRegistry;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public final class DiagramRefresherHelper {
    private DiagramRefresherHelper() {
    }

    public static void refreshEditParts(DDiagram diagram, Collection<EditPart> editParts) {
        if (diagram != null) {
            RefreshActionListenerRegistry.INSTANCE.notifyRepresentationIsAboutToBeRefreshed((DRepresentation)diagram);
        }
        Shell activeShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(activeShell);
        try {
            monitorDialog.run(true, false, (IRunnableWithProgress)new RefreshRunnableWithProgress(editParts));
        }
        catch (InvocationTargetException e) {
            MessageDialog.openError((Shell)activeShell, (String)Messages.RefreshDiagramAction_error, (String)e.getTargetException().getMessage());
            SiriusPlugin.getDefault().error(Messages.RefreshDiagramAction_refreshDiagramError, (Throwable)e);
        }
        catch (InterruptedException e) {
            MessageDialog.openInformation((Shell)activeShell, (String)Messages.RefreshDiagramAction_cancelled, (String)e.getMessage());
        }
    }
}

