/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.message;

import java.util.Map;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.HTTPUtils;

public class BP1006
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP1006(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    @Override
    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        String rawHTTPHeader = entryContext.getMessageEntry().getHTTPHeaders();
        Map httpHeader = HTTPUtils.getHttpHeaderTokens(rawHTTPHeader, ":");
        String soapAction = (String)httpHeader.get("SOAPAction".toUpperCase());
        if (soapAction == null) {
            this.result = "notApplicable";
        } else if (!soapAction.startsWith("\"") || !soapAction.endsWith("\"")) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail("HTTP Header: \"" + rawHTTPHeader + "\".", entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

