/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.serializer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.xtext.base.serializer.EClassValue;
import org.eclipse.ocl.xtext.base.serializer.EnumerationValue;
import org.eclipse.ocl.xtext.base.serializer.GrammarRuleVector;
import org.eclipse.ocl.xtext.base.serializer.SerializationMetaData;
import org.eclipse.ocl.xtext.base.serializer.SerializationRule;

public interface UserSlotAnalysis {
    public int asCounted();

    public int asDiscriminated(@NonNull GrammarRuleVector var1);

    public int asEnumerated(@NonNull EnumerationValue var1);

    public boolean isCounted();

    public boolean isDiscriminated();

    public boolean isEnumerated();

    public static class CountedSlotAnalysis
    implements UserSlotAnalysis {
        private static final @NonNull CountedSlotAnalysis ZERO = new CountedSlotAnalysis(0);
        private static @NonNull CountedSlotAnalysis ONE = new CountedSlotAnalysis(1);
        protected final int count;

        public static @NonNull CountedSlotAnalysis valueOf(int value) {
            switch (value) {
                case 0: {
                    return ZERO;
                }
                case 1: {
                    return ONE;
                }
            }
            return new CountedSlotAnalysis(value);
        }

        private CountedSlotAnalysis(int count) {
            this.count = count;
        }

        @Override
        public int asCounted() {
            return this.count >= 0 ? this.count : 0;
        }

        @Override
        public int asDiscriminated(@NonNull GrammarRuleVector grammarRuleVector) {
            throw new IllegalStateException();
        }

        @Override
        public int asEnumerated(@NonNull EnumerationValue enumerationValue) {
            throw new IllegalStateException();
        }

        @Override
        public boolean isCounted() {
            return true;
        }

        @Override
        public boolean isDiscriminated() {
            return false;
        }

        @Override
        public boolean isEnumerated() {
            return false;
        }

        public @NonNull String toString() {
            return Integer.toString(this.count);
        }
    }

    public static class DiscriminatedSlotAnalysis
    implements UserSlotAnalysis {
        private final @NonNull Map<@NonNull GrammarRuleVector, @NonNull Integer> grammarRuleVector2count = new HashMap<GrammarRuleVector, Integer>();

        public DiscriminatedSlotAnalysis(@NonNull SerializationMetaData serializationMetaData, @NonNull Iterable<@NonNull GrammarRuleVector> grammarRuleValues, @NonNull EObject eObject) {
            this.analyzeEObject(serializationMetaData, grammarRuleValues, eObject, false);
        }

        public DiscriminatedSlotAnalysis(@NonNull SerializationMetaData serializationMetaData, @NonNull Iterable<@NonNull GrammarRuleVector> grammarRuleVectors, @NonNull Iterable<@NonNull EObject> eObjects) {
            for (EObject eObject : eObjects) {
                boolean bl = this.analyzeEObject(serializationMetaData, grammarRuleVectors, eObject, true);
            }
        }

        protected boolean analyzeEObject(@NonNull SerializationMetaData serializationMetaData, @NonNull Iterable<@NonNull GrammarRuleVector> grammarRuleVectors, @NonNull EObject eObject, boolean isMany) {
            boolean gotOne = false;
            EClass eClass = eObject.eClass();
            assert (eClass != null);
            EClassValue eClassValue = serializationMetaData.getEClassValue(eClass);
            GrammarRuleVector eObjectGrammarRuleVector = new GrammarRuleVector();
            SerializationRule[] serializationRuleArray = eClassValue.getSerializationRules();
            int n = serializationRuleArray.length;
            int n2 = 0;
            while (n2 < n) {
                SerializationRule serializationRule = serializationRuleArray[n2];
                eObjectGrammarRuleVector.set(serializationRule.getGrammarRuleValueIndex());
                ++n2;
            }
            for (GrammarRuleVector grammarRuleVector : grammarRuleVectors) {
                if (!grammarRuleVector.testAny(eObjectGrammarRuleVector)) continue;
                Integer count = isMany ? this.grammarRuleVector2count.get(grammarRuleVector) : null;
                this.grammarRuleVector2count.put(grammarRuleVector, count == null ? 1 : count + 1);
                gotOne = true;
            }
            return gotOne;
        }

        @Override
        public int asCounted() {
            throw new IllegalStateException();
        }

        @Override
        public int asDiscriminated(@NonNull GrammarRuleVector grammarRuleVector) {
            Integer value = this.grammarRuleVector2count.get(grammarRuleVector);
            return value != null ? value : 0;
        }

        @Override
        public int asEnumerated(@NonNull EnumerationValue enumerationValue) {
            throw new IllegalStateException();
        }

        @Override
        public boolean isCounted() {
            return false;
        }

        @Override
        public boolean isDiscriminated() {
            return true;
        }

        @Override
        public boolean isEnumerated() {
            return false;
        }

        public @NonNull String toString() {
            StringBuilder s = new StringBuilder();
            ArrayList<@NonNull GrammarRuleVector> keys = new ArrayList<GrammarRuleVector>(this.grammarRuleVector2count.keySet());
            Collections.sort(keys);
            boolean isFirst = true;
            for (GrammarRuleVector key : keys) {
                if (!isFirst) {
                    s.append(",");
                }
                s.append(key);
                s.append("=");
                s.append(this.grammarRuleVector2count.get(key));
                isFirst = false;
            }
            return s.toString();
        }
    }

    public static class EnumeratedSlotAnalysis
    implements UserSlotAnalysis {
        private final @NonNull Map<@NonNull EnumerationValue, @NonNull Integer> enumerationValue2count = new HashMap<EnumerationValue, Integer>();

        public EnumeratedSlotAnalysis(@NonNull Iterable<@NonNull EnumerationValue> enumerationValues, @Nullable Object value) {
            assert (value != null);
            boolean gotOne = this.analyzeValue(enumerationValues, value, false);
            this.enumerationValue2count.put(EnumerationValue.EnumerationValueOthers.INSTANCE, gotOne ? 0 : 1);
            this.enumerationValue2count.put(EnumerationValue.EnumerationValueAny.INSTANCE, 1);
        }

        public EnumeratedSlotAnalysis(@NonNull Iterable<@NonNull EnumerationValue> enumerationValues, @NonNull Iterable<?> elements) {
            int any = 0;
            int others = 0;
            for (Object element : elements) {
                boolean gotOne = this.analyzeValue(enumerationValues, element, true);
                if (!gotOne) {
                    ++others;
                }
                ++any;
            }
            this.enumerationValue2count.put(EnumerationValue.EnumerationValueOthers.INSTANCE, others);
            this.enumerationValue2count.put(EnumerationValue.EnumerationValueAny.INSTANCE, any);
        }

        protected boolean analyzeValue(@NonNull Iterable<@NonNull EnumerationValue> enumerationValues, Object value, boolean isMany) {
            @NonNull String string = String.valueOf(value);
            boolean gotOne = false;
            for (EnumerationValue enumerationValue : enumerationValues) {
                if (!enumerationValue.isElement(string)) continue;
                Integer count = isMany ? this.enumerationValue2count.get(enumerationValue) : null;
                this.enumerationValue2count.put(enumerationValue, count == null ? 1 : count + 1);
                gotOne = true;
            }
            return gotOne;
        }

        @Override
        public int asCounted() {
            return (Integer)ClassUtil.nonNullState((Object)this.enumerationValue2count.get(EnumerationValue.EnumerationValueAny.INSTANCE));
        }

        @Override
        public int asDiscriminated(@NonNull GrammarRuleVector grammarRuleVector) {
            throw new IllegalStateException();
        }

        @Override
        public int asEnumerated(@NonNull EnumerationValue enumerationValue) {
            Integer value = this.enumerationValue2count.get(enumerationValue);
            return value != null ? value : 0;
        }

        @Override
        public boolean isCounted() {
            return false;
        }

        @Override
        public boolean isDiscriminated() {
            return false;
        }

        @Override
        public boolean isEnumerated() {
            return true;
        }

        public @NonNull String toString() {
            StringBuilder s = new StringBuilder();
            ArrayList<@NonNull EnumerationValue> keys = new ArrayList<EnumerationValue>(this.enumerationValue2count.keySet());
            Collections.sort(keys, NameUtil.NAMEABLE_COMPARATOR);
            boolean isFirst = true;
            for (EnumerationValue key : keys) {
                if (!isFirst) {
                    s.append(",");
                }
                s.append(key);
                s.append("=");
                s.append(this.enumerationValue2count.get(key));
                isFirst = false;
            }
            return s.toString();
        }
    }
}

