/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.php.internal.debug.core.model.IVariableFacet;
import org.eclipse.php.internal.debug.core.zend.debugger.Expression;
import org.eclipse.php.internal.debug.core.zend.debugger.ExpressionValue;

public class DefaultExpression
implements Expression {
    private String[] name;
    private String fullName;
    private ExpressionValue expressionValue;
    private Set<IVariableFacet.Facet> facets = new HashSet<IVariableFacet.Facet>();

    public DefaultExpression(String expression) {
        this(expression, expression);
    }

    public DefaultExpression(String expression, String fullName) {
        this.name = new String[]{expression.trim()};
        this.fullName = fullName;
        this.setValue(null);
    }

    public DefaultExpression(String expression, IVariableFacet.Facet ... facets) {
        this(expression, expression, facets);
    }

    public DefaultExpression(String expression, String fullName, IVariableFacet.Facet ... facets) {
        this.name = new String[]{expression.trim()};
        this.fullName = fullName;
        this.setValue(null);
        this.addFacets(facets);
    }

    protected DefaultExpression(Expression parent, String name, String representation, IVariableFacet.Facet ... facets) {
        String[] parentName = parent.getName();
        this.name = new String[parentName.length + 1];
        System.arraycopy(parentName, 0, this.name, 0, parentName.length);
        this.name[parentName.length] = name;
        this.fullName = parent.getFullName() + representation;
        this.setValue(null);
        this.setChildFacets(name, facets);
        this.addFacets(facets);
    }

    private void setChildFacets(String name, IVariableFacet.Facet ... facets) {
        IVariableFacet.Facet[] facetArray = facets;
        int n = facets.length;
        int n2 = 0;
        while (n2 < n) {
            IVariableFacet.Facet facet = facetArray[n2];
            if (facet == IVariableFacet.Facet.KIND_OBJECT_MEMBER) {
                if (name.startsWith("*::")) {
                    this.addFacets(IVariableFacet.Facet.MOD_PROTECTED);
                } else if (name.contains("::")) {
                    this.addFacets(IVariableFacet.Facet.MOD_PRIVATE);
                } else {
                    this.addFacets(IVariableFacet.Facet.MOD_PUBLIC);
                }
            }
            ++n2;
        }
    }

    @Override
    public void addFacets(IVariableFacet.Facet ... facets) {
        IVariableFacet.Facet[] facetArray = facets;
        int n = facets.length;
        int n2 = 0;
        while (n2 < n) {
            IVariableFacet.Facet facet = facetArray[n2];
            this.facets.add(facet);
            ++n2;
        }
    }

    @Override
    public Expression createChildExpression(String endName, String endRepresentation, IVariableFacet.Facet ... facets) {
        return new DefaultExpression(this, endName, endRepresentation, facets);
    }

    @Override
    public String[] getName() {
        return this.name;
    }

    @Override
    public String getLastName() {
        return this.name[this.name.length - 1];
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public ExpressionValue getValue() {
        return this.expressionValue;
    }

    @Override
    public boolean hasFacet(IVariableFacet.Facet facet) {
        return this.facets.contains((Object)facet);
    }

    @Override
    public void setValue(ExpressionValue value) {
        if (value == null) {
            value = ExpressionValue.NULL_VALUE;
        }
        this.expressionValue = value;
    }

    public String toString() {
        return this.getLastName() + " = " + this.getValue().getValueAsString();
    }
}

