/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.findReferences;

import com.google.inject.Inject;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.findReferences.IReferenceFinder;
import org.eclipse.xtext.findReferences.TargetURIs;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class Declarators {
    public static final TargetURIs.Key<DeclaratorsData> KEY = TargetURIs.Key.from((String)"Xtend", DeclaratorsData.class);
    @Inject
    private IQualifiedNameConverter nameConverter;

    public DeclaratorsData getDeclaratorData(TargetURIs targetURIs, IReferenceFinder.IResourceAccess resourceAccess) {
        DeclaratorsData _declaratorsData;
        DeclaratorsData result = (DeclaratorsData)targetURIs.getUserData(KEY);
        if (result != null) {
            return result;
        }
        HashSet declaratorNames = CollectionLiterals.newHashSet();
        Consumer<URI> _function = uri -> {
            IUnitOfWork _function_1 = it -> {
                Object _xblockexpression = null;
                Consumer<URI> _function_2 = objectURI -> {
                    JvmType type;
                    EObject object = it.getEObject(objectURI, true);
                    if (object != null && (type = (JvmType)EcoreUtil2.getContainerOfType((EObject)object, JvmType.class)) != null) {
                        QualifiedName _lowerCase = this.nameConverter.toQualifiedName(type.getIdentifier()).toLowerCase();
                        declaratorNames.add(_lowerCase);
                        QualifiedName _lowerCase_1 = this.nameConverter.toQualifiedName(type.getQualifiedName('.')).toLowerCase();
                        declaratorNames.add(_lowerCase_1);
                    }
                };
                targetURIs.getEObjectURIs(uri).forEach(_function_2);
                _xblockexpression = null;
                return _xblockexpression;
            };
            resourceAccess.readOnly(uri, _function_1);
        };
        targetURIs.getTargetResourceURIs().forEach(_function);
        result = _declaratorsData = new DeclaratorsData(declaratorNames);
        targetURIs.putUserData(KEY, (Object)result);
        return result;
    }

    @Data
    public static class DeclaratorsData {
        private final Set<QualifiedName> declaratorNames;

        public DeclaratorsData(Set<QualifiedName> declaratorNames) {
            this.declaratorNames = declaratorNames;
        }

        @Pure
        public int hashCode() {
            return 31 + (this.declaratorNames == null ? 0 : this.declaratorNames.hashCode());
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DeclaratorsData other = (DeclaratorsData)obj;
            return !(this.declaratorNames == null ? other.declaratorNames != null : !this.declaratorNames.equals(other.declaratorNames));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("declaratorNames", this.declaratorNames);
            return b.toString();
        }

        @Pure
        public Set<QualifiedName> getDeclaratorNames() {
            return this.declaratorNames;
        }
    }
}

