/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.launching;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.dltk.launching.IRuntimeBuildpathEntry;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.launching.StandardBuildpathProvider;

public class StandardSourcepathProvider
extends StandardBuildpathProvider {
    @Override
    public IRuntimeBuildpathEntry[] computeUnresolvedBuildpath(ILaunchConfiguration configuration) throws CoreException {
        boolean useDefault = configuration.getAttribute("defaultSourcePath", true);
        IRuntimeBuildpathEntry[] entries = null;
        entries = useDefault ? super.computeUnresolvedBuildpath(configuration) : this.recoverRuntimePath(configuration, "sourcePath");
        return entries;
    }

    @Override
    public IRuntimeBuildpathEntry[] resolveBuildpath(IRuntimeBuildpathEntry[] entries, ILaunchConfiguration configuration) throws CoreException {
        UniqueList<IRuntimeBuildpathEntry> all = new UniqueList<IRuntimeBuildpathEntry>(entries.length);
        int i = 0;
        while (i < entries.length) {
            switch (entries[i].getType()) {
                case 1: {
                    all.add(entries[i]);
                    break;
                }
                default: {
                    IRuntimeBuildpathEntry[] resolved = ScriptRuntime.resolveRuntimeBuildpathEntry(entries[1], configuration);
                    all.add(resolved);
                }
            }
            ++i;
        }
        return all.toArray(new IRuntimeBuildpathEntry[all.size()]);
    }

    class UniqueList<T>
    extends ArrayList<T> {
        private static final long serialVersionUID = -7402160651027036270L;
        HashSet<T> set;

        public UniqueList(int length) {
            super(length);
            this.set = new HashSet(length);
        }

        @Override
        public void add(int index, T element) {
            if (this.set.add(element)) {
                super.add(index, element);
            }
        }

        @Override
        public boolean add(T o) {
            if (this.set.add(o)) {
                return super.add(o);
            }
            return false;
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            if (this.set.addAll(c)) {
                return super.addAll(c);
            }
            return false;
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            if (this.set.addAll(c)) {
                return super.addAll(index, c);
            }
            return false;
        }

        @Override
        public void clear() {
            this.set.clear();
            super.clear();
        }

        @Override
        public boolean contains(Object elem) {
            return this.set.contains(elem);
        }

        @Override
        public void ensureCapacity(int minCapacity) {
            super.ensureCapacity(minCapacity);
        }

        @Override
        public T remove(int index) {
            Object object = super.remove(index);
            this.set.remove(object);
            return (T)object;
        }

        @Override
        protected void removeRange(int fromIndex, int toIndex) {
            int index = fromIndex;
            while (index <= toIndex) {
                this.remove(index);
                ++index;
            }
        }

        @Override
        public T set(int index, T element) {
            this.set.remove(element);
            if (this.set.add(element)) {
                return super.set(index, element);
            }
            return null;
        }
    }
}

