/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.factory;

import org.eclipse.jpt.common.utility.factory.Factory;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.ClassTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;

public class InstantiationFactory<T>
implements Factory<T> {
    private final Class<? extends T> clazz;
    private final Class<?>[] parameterTypes;
    private final Object[] arguments;

    public InstantiationFactory(Class<? extends T> clazz, Class<?>[] parameterTypes, Object[] arguments) {
        if (clazz == null || ArrayTools.isOrContainsNull(parameterTypes) || arguments == null) {
            throw new NullPointerException();
        }
        this.clazz = clazz;
        this.parameterTypes = parameterTypes;
        this.arguments = arguments;
    }

    @Override
    public T create() {
        return ClassTools.newInstance(this.clazz, this.parameterTypes, this.arguments);
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.clazz.getSimpleName());
    }
}

