/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.value;

import java.util.Arrays;
import org.eclipse.jpt.common.utility.internal.model.value.ValueAspectAdapter;
import org.eclipse.jpt.common.utility.model.Model;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;

public class ValuePropertyAdapter<V extends Model>
extends ValueAspectAdapter<V> {
    protected final String[] propertyNames;
    protected final PropertyChangeListener valuePropertyListener;

    public ValuePropertyAdapter(ModifiablePropertyValueModel<V> valueHolder, String ... propertyNames) {
        super(valueHolder);
        if (propertyNames == null) {
            throw new NullPointerException();
        }
        this.propertyNames = propertyNames;
        this.valuePropertyListener = this.buildValuePropertyListener();
    }

    protected PropertyChangeListener buildValuePropertyListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChanged(PropertyChangeEvent event) {
                ValuePropertyAdapter.this.propertyChanged(event);
            }

            public String toString() {
                return "value property listener: " + Arrays.asList(ValuePropertyAdapter.this.propertyNames);
            }
        };
    }

    @Override
    protected void engageValue_() {
        String[] stringArray = this.propertyNames;
        int n = this.propertyNames.length;
        int n2 = 0;
        while (n2 < n) {
            String propertyName = stringArray[n2];
            ((Model)this.value).addPropertyChangeListener(propertyName, this.valuePropertyListener);
            ++n2;
        }
    }

    @Override
    protected void disengageValue_() {
        String[] stringArray = this.propertyNames;
        int n = this.propertyNames.length;
        int n2 = 0;
        while (n2 < n) {
            String propertyName = stringArray[n2];
            ((Model)this.value).removePropertyChangeListener(propertyName, this.valuePropertyListener);
            ++n2;
        }
    }

    protected void propertyChanged(PropertyChangeEvent event) {
        this.valueAspectChanged();
    }
}

