/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.swt.tools.internal.JNIClass;
import org.eclipse.swt.tools.internal.JNIField;
import org.eclipse.swt.tools.internal.JNIGenerator;
import org.eclipse.swt.tools.internal.JNIMethod;
import org.eclipse.swt.tools.internal.MetaData;
import org.eclipse.swt.tools.internal.ReflectField;
import org.eclipse.swt.tools.internal.ReflectItem;
import org.eclipse.swt.tools.internal.ReflectMethod;

public class ReflectClass
extends ReflectItem
implements JNIClass {
    Class<?> clazz;
    ReflectField[] fields;
    ReflectMethod[] methods;
    MetaData metaData;
    String sourcePath;

    public ReflectClass(Class<?> clazz) {
        this(clazz, null, null);
    }

    public ReflectClass(Class<?> clazz, MetaData data, String sourcePath) {
        this.clazz = clazz;
        this.metaData = data;
        this.sourcePath = sourcePath;
    }

    void checkMembers() {
        if (this.fields != null) {
            return;
        }
        String source = null;
        source = JNIGenerator.loadFile(this.sourcePath);
        ASTParser parser = ASTParser.newParser((int)AST.getJLSLatest());
        parser.setSource(source.toCharArray());
        parser.createAST(null);
        Field[] fields = this.clazz.getDeclaredFields();
        this.fields = new ReflectField[fields.length];
        int i = 0;
        while (i < fields.length) {
            this.fields[i] = new ReflectField(this, fields[i]);
            ++i;
        }
        Method[] methods = this.clazz.getDeclaredMethods();
        this.methods = new ReflectMethod[methods.length];
        int i2 = 0;
        while (i2 < methods.length) {
            this.methods[i2] = new ReflectMethod(this, methods[i2]);
            ++i2;
        }
    }

    public int hashCode() {
        return this.clazz.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ReflectClass)) {
            return false;
        }
        return ((ReflectClass)obj).clazz.equals(this.clazz);
    }

    @Override
    public JNIField[] getDeclaredFields() {
        this.checkMembers();
        JNIField[] result = new JNIField[this.fields.length];
        System.arraycopy(this.fields, 0, result, 0, result.length);
        return result;
    }

    @Override
    public JNIMethod[] getDeclaredMethods() {
        this.checkMembers();
        JNIMethod[] result = new JNIMethod[this.methods.length];
        System.arraycopy(this.methods, 0, result, 0, result.length);
        return result;
    }

    @Override
    public String getName() {
        return this.clazz.getName();
    }

    @Override
    public JNIClass getSuperclass() {
        Class<?> superclazz = this.clazz.getSuperclass();
        String path = new File(this.sourcePath).getParent() + "/" + this.getSimpleName(superclazz) + ".java";
        return new ReflectClass(superclazz, this.metaData, path);
    }

    String getSimpleName(Class<?> type) {
        String name = type.getName();
        int index = name.lastIndexOf(46) + 1;
        return name.substring(index, name.length());
    }

    @Override
    public String getSimpleName() {
        return this.getSimpleName(this.clazz);
    }

    @Override
    public String getExclude() {
        return (String)this.getParam("exclude");
    }

    @Override
    public String getMetaData() {
        String key = JNIGenerator.toC(this.clazz.getName());
        return this.metaData.getMetaData(key, "");
    }

    @Override
    public void setExclude(String str) {
        this.setParam("exclude", str);
    }

    @Override
    public void setMetaData(String value) {
        String key = JNIGenerator.toC(this.clazz.getName());
        this.metaData.setMetaData(key, value);
    }

    public String toString() {
        return this.clazz.toString();
    }
}

