/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.util.grid;

import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.internal.core.utils.state.GlobalState;
import org.eclipse.wb.internal.core.utils.state.IParametersProvider;

public final class GridAlignmentHelper {
    public static final String V_GRAB_HORIZONTAL = "gridLayout.grabHorizontal";
    public static final String V_GRAB_VERTICAL = "gridLayout.grabVertical";
    public static final String V_RIGHT_LABEL = "gridLayout.rightAlignment.isLabel";
    public static final String V_RIGHT_TARGET = "gridLayout.rightAlignment.isTarget";

    private GridAlignmentHelper() {
    }

    public static <C extends IAbstractComponentInfo> void doAutomaticAlignment(C component, IAlignmentProcessor<C> processor) throws Exception {
        IParametersProvider parametersProvider = GlobalState.getParametersProvider();
        if (processor.grabEnabled()) {
            if (parametersProvider.hasTrueParameter(component, V_GRAB_HORIZONTAL)) {
                processor.setGrabFill(component, true);
            }
            if (parametersProvider.hasTrueParameter(component, V_GRAB_VERTICAL)) {
                processor.setGrabFill(component, false);
            }
        }
        if (processor.rightEnabled()) {
            C leftComponent;
            C rightComponent;
            if (parametersProvider.hasTrueParameter(component, V_RIGHT_LABEL) && (rightComponent = processor.getComponentAtRight(component)) != null && parametersProvider.hasTrueParameter(rightComponent, V_RIGHT_TARGET)) {
                processor.setRightAlignment(component);
            }
            if (parametersProvider.hasTrueParameter(component, V_RIGHT_TARGET) && (leftComponent = processor.getComponentAtLeft(component)) != null && parametersProvider.hasTrueParameter(leftComponent, V_RIGHT_LABEL)) {
                processor.setRightAlignment(leftComponent);
            }
        }
    }

    public static interface IAlignmentProcessor<C extends IAbstractComponentInfo> {
        public boolean grabEnabled();

        public boolean rightEnabled();

        public C getComponentAtLeft(C var1);

        public C getComponentAtRight(C var1);

        public void setGrabFill(C var1, boolean var2) throws Exception;

        public void setRightAlignment(C var1) throws Exception;
    }
}

