/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.parser.impl;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;
import org.eclipse.xtext.parser.antlr.Lexer;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.ReplaceRegion;
import org.eclipse.xtext.util.TextRegion;

public class TokenRegionProvider {
    @Inject
    @Named(value="org.eclipse.xtext.parser.antlr.Lexer.RUNTIME")
    private Provider<Lexer> lexerProvider;

    public ITextRegion getTokenRegion(String text, ITextRegion region) {
        Lexer lexer = (Lexer)((Object)this.lexerProvider.get());
        lexer.setCharStream((CharStream)new ANTLRStringStream(text));
        int currentStart = 0;
        int currentEnd = 0;
        CommonToken nextToken = (CommonToken)lexer.nextToken();
        int regionStart = region.getOffset();
        int regionEnd = region.getEndOffset();
        while (nextToken != Token.EOF_TOKEN && currentEnd <= regionStart) {
            currentStart = nextToken.getStartIndex();
            currentEnd = nextToken.getStopIndex() + 1;
            nextToken = (CommonToken)lexer.nextToken();
        }
        while (nextToken != Token.EOF_TOKEN && currentEnd < regionEnd) {
            currentEnd = nextToken.getStopIndex() + 1;
            nextToken = (CommonToken)lexer.nextToken();
        }
        if (currentStart != regionStart || currentEnd != regionEnd) {
            return new TextRegion(currentStart, currentEnd - currentStart);
        }
        return region;
    }

    public ReplaceRegion getTokenReplaceRegion(String changedText, ReplaceRegion replaceRegion) {
        int lengthDelta = replaceRegion.getText().length() - replaceRegion.getLength();
        ITextRegion tokenRegion = this.getTokenRegion(changedText, (ITextRegion)new TextRegion(replaceRegion.getOffset(), replaceRegion.getText().length()));
        if (tokenRegion.getOffset() == replaceRegion.getOffset() && tokenRegion.getLength() == replaceRegion.getText().length()) {
            return replaceRegion;
        }
        return new ReplaceRegion(tokenRegion.getOffset(), tokenRegion.getLength() - lengthDelta, changedText.substring(tokenRegion.getOffset(), tokenRegion.getOffset() + tokenRegion.getLength()));
    }
}

