/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.benchmarks.rebind;

import com.google.gwt.benchmarks.BenchmarkShell;
import com.google.gwt.benchmarks.client.IterationTimeLimit;
import com.google.gwt.benchmarks.client.RangeEnum;
import com.google.gwt.benchmarks.client.RangeField;
import com.google.gwt.benchmarks.client.Setup;
import com.google.gwt.benchmarks.client.Teardown;
import com.google.gwt.benchmarks.client.impl.BenchmarkResults;
import com.google.gwt.benchmarks.client.impl.IterableAdapter;
import com.google.gwt.benchmarks.client.impl.PermutationIterator;
import com.google.gwt.benchmarks.client.impl.Trial;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JField;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.core.ext.typeinfo.JParameter;
import com.google.gwt.dev.generator.ast.Expression;
import com.google.gwt.dev.generator.ast.ForLoop;
import com.google.gwt.dev.generator.ast.MethodCall;
import com.google.gwt.dev.generator.ast.Statement;
import com.google.gwt.dev.generator.ast.Statements;
import com.google.gwt.dev.generator.ast.StatementsList;
import com.google.gwt.junit.rebind.JUnitTestCaseStubGenerator;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.IncrementalCommand;
import com.google.gwt.user.rebind.SourceWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BenchmarkGenerator
extends JUnitTestCaseStubGenerator {
    private static final String BEGIN_PREFIX = "begin";
    private static final String BENCHMARK_PARAM_META = "gwt.benchmark.param";
    private static final String BENCHMARK_RESULTS_CLASS = BenchmarkResults.class.getName();
    private static long defaultTimeout = -1L;
    private static final String EMPTY_FUNC = "__emptyFunc";
    private static final String END_PREFIX = "end";
    private static final String ESCAPE_LOOP = "__escapeLoop";
    private static final String ITERABLE_ADAPTER_CLASS = IterableAdapter.class.getName();
    private static final String PERMUTATION_ITERATOR_CLASS = PermutationIterator.class.getName();
    private static final String TRIAL_CLASS = Trial.class.getName();

    public static Map<String, JMethod> getNotOverloadedTestMethods(JClassType requestedClass) {
        Map<String, List<JMethod>> methods = BenchmarkGenerator.getAllMethods(requestedClass, new JUnitTestCaseStubGenerator.MethodFilter(){

            public boolean accept(JMethod method) {
                return BenchmarkGenerator.isJUnitTestMethod(method, true);
            }
        });
        HashMap<String, JMethod> notOverloadedMethods = new HashMap<String, JMethod>();
        for (Map.Entry<String, List<JMethod>> entry : methods.entrySet()) {
            JMethod overload;
            List<JMethod> methodOverloads = entry.getValue();
            if (methodOverloads.size() != 1 || (overload = methodOverloads.get(0)).getParameters().length != 0) continue;
            notOverloadedMethods.put(entry.getKey(), overload);
        }
        return notOverloadedMethods;
    }

    public static Map<String, JMethod> getParameterizedTestMethods(JClassType requestedClass, TreeLogger logger) {
        Map<String, List<JMethod>> testMethods = BenchmarkGenerator.getAllMethods(requestedClass, new JUnitTestCaseStubGenerator.MethodFilter(){

            public boolean accept(JMethod method) {
                return BenchmarkGenerator.isJUnitTestMethod(method, true);
            }
        });
        HashMap<String, JMethod> overloadedMethods = new HashMap<String, JMethod>();
        for (Map.Entry<String, List<JMethod>> entry : testMethods.entrySet()) {
            String name = entry.getKey();
            List<JMethod> methods = entry.getValue();
            if (methods.size() > 2) {
                String msg = requestedClass + "." + name + " has more than one overloaded version" + "; it will not be included in the test case execution";
                logger.log(TreeLogger.WARN, msg, null);
                continue;
            }
            if (methods.size() == 1) {
                JMethod method = methods.get(0);
                if (method.getParameters().length == 0) continue;
                String msg = requestedClass + "." + name + " does not have a zero-argument overload" + "; it will not be included in the test case execution";
                logger.log(TreeLogger.WARN, msg, null);
                continue;
            }
            JMethod method1 = methods.get(0);
            JMethod method2 = methods.get(1);
            JMethod noArgMethod = null;
            JMethod overloadedMethod = null;
            if (method1.getParameters().length == 0) {
                noArgMethod = method1;
            } else {
                overloadedMethod = method1;
            }
            if (method2.getParameters().length == 0) {
                noArgMethod = method2;
            } else {
                overloadedMethod = method2;
            }
            if (noArgMethod == null) {
                String msg = requestedClass + "." + name + " does not have a zero-argument overload" + "; it will not be included in the test case execution";
                logger.log(TreeLogger.WARN, msg, null);
                continue;
            }
            overloadedMethods.put(entry.getKey(), overloadedMethod);
        }
        return overloadedMethods;
    }

    private static JMethod getBeginMethod(JClassType type, JMethod method) {
        Setup setup = (Setup)method.getAnnotation(Setup.class);
        String methodName = setup != null ? setup.value() : new StringBuffer(method.getName()).replace(0, "test".length(), BEGIN_PREFIX).toString();
        return BenchmarkGenerator.getMethod(type, methodName);
    }

    private static JMethod getEndMethod(JClassType type, JMethod method) {
        Teardown teardown = (Teardown)method.getAnnotation(Teardown.class);
        String methodName = teardown != null ? teardown.value() : new StringBuffer(method.getName()).replace(0, "test".length(), END_PREFIX).toString();
        return BenchmarkGenerator.getMethod(type, methodName);
    }

    private static JMethod getMethod(JClassType type, JUnitTestCaseStubGenerator.MethodFilter filter) {
        Map<String, List<JMethod>> map = BenchmarkGenerator.getAllMethods(type, filter);
        Set<Map.Entry<String, List<JMethod>>> entrySet = map.entrySet();
        if (entrySet.size() == 0) {
            return null;
        }
        List<JMethod> methods = entrySet.iterator().next().getValue();
        return methods.get(0);
    }

    private static JMethod getMethod(JClassType type, final String name) {
        return BenchmarkGenerator.getMethod(type, new JUnitTestCaseStubGenerator.MethodFilter(){

            public boolean accept(JMethod method) {
                return method.getName().equals(name);
            }
        });
    }

    @Override
    public void writeSource() throws UnableToCompleteException {
        super.writeSource();
        this.generateEmptyFunc(this.getSourceWriter());
        this.implementZeroArgTestMethods();
        this.implementParameterizedTestMethods();
        this.generateAsyncCode();
        BenchmarkShell.getReport().addBenchmark(this.logger, this.getRequestedClass());
    }

    private Statements benchmark(Statements stmts, String timeMillisName, long bound, Statements recordCode, Statements breakCode) {
        StatementsList benchmarkCode = new StatementsList();
        List benchStatements = benchmarkCode.getStatements();
        ForLoop loop = new ForLoop("int numLoops = 1", "true", "");
        benchStatements.add(loop);
        List loopStatements = loop.getStatements();
        loopStatements.add(new Statement("long start = System.currentTimeMillis()"));
        ForLoop runLoop = new ForLoop("int i = 0", "i < numLoops", "++i", stmts);
        loopStatements.add(runLoop);
        String benchCode = "long duration = System.currentTimeMillis() - start;\n\nif ( duration < 150 ) {\n  numLoops += numLoops;\n  continue;\n}\n\ndouble durationMillis = duration * 1.0;\ndouble numLoopsAsDouble = numLoops * 1.0;\n" + timeMillisName + " = durationMillis / numLoopsAsDouble";
        loopStatements.add(new Statement(benchCode));
        if (recordCode != null) {
            loopStatements.add(recordCode);
        }
        if (bound != 0L) {
            loopStatements.add(new Statement("if ( numLoops == 1 && duration > " + bound + " ) {\n" + breakCode.toString() + "\n" + "}\n\n"));
        }
        loopStatements.add(new Statement("break"));
        return benchmarkCode;
    }

    private boolean fieldExists(JClassType type, String fieldName) {
        JField field = type.findField(fieldName);
        if (field == null) {
            JClassType superClass = type.getSuperclass();
            if (superClass == null) {
                return false;
            }
            return this.fieldExists(superClass, fieldName);
        }
        return true;
    }

    private Statements genBenchTarget(JMethod beginMethod, JMethod endMethod, List<String> paramNames, Statements test) {
        StatementsList statements = new StatementsList();
        List statementsList = statements.getStatements();
        if (beginMethod != null) {
            statementsList.add(new Statement((Expression)new MethodCall(beginMethod.getName(), paramNames)));
        }
        statementsList.add(test);
        if (endMethod != null) {
            statementsList.add(new Statement((Expression)new MethodCall(endMethod.getName(), null)));
        }
        return statements;
    }

    private void generateAsyncCode() {
        SourceWriter writer = this.getSourceWriter();
        writer.println("private boolean supportsAsync;");
        writer.println();
        writer.println("public boolean supportsAsync() {");
        writer.println("  return supportsAsync;");
        writer.println("}");
        writer.println();
        writer.println("private void privateDelayTestFinish(int timeout) {");
        writer.println("  supportsAsync = true;");
        writer.println("  try {");
        writer.println("    delayTestFinish(timeout);");
        writer.println("  } finally {");
        writer.println("    supportsAsync = false;");
        writer.println("  }");
        writer.println("}");
        writer.println();
        writer.println("private void privateFinishTest() {");
        writer.println("  supportsAsync = true;");
        writer.println("  try {");
        writer.println("    finishTest();");
        writer.println("  } finally {");
        writer.println("    supportsAsync = false;");
        writer.println("  }");
        writer.println("}");
        writer.println();
    }

    private void generateEmptyFunc(SourceWriter writer) {
        writer.println("private native void __emptyFunc() /*-{");
        writer.println("}-*/;");
        writer.println();
    }

    private Map<String, String> getAnnotationMetaData(JMethod method, MutableLong bound) throws UnableToCompleteException {
        JParameter[] params;
        IterationTimeLimit limit = (IterationTimeLimit)method.getAnnotation(IterationTimeLimit.class);
        bound.value = limit == null ? this.getDefaultTimeout() : limit.value();
        HashMap<String, String> paramMetaData = new HashMap<String, String>();
        for (JParameter param : params = method.getParameters()) {
            RangeField rangeField = (RangeField)param.getAnnotation(RangeField.class);
            if (rangeField != null) {
                String fieldName = rangeField.value();
                JClassType enclosingType = method.getEnclosingType();
                if (!this.fieldExists(enclosingType, fieldName)) {
                    this.logger.log(TreeLogger.ERROR, "The RangeField annotation on " + enclosingType + " at " + method + " specifies a field, " + fieldName + ", which could not be found. Perhaps it is " + "mis-spelled?", null);
                    throw new UnableToCompleteException();
                }
                paramMetaData.put(param.getName(), fieldName);
                continue;
            }
            RangeEnum rangeEnum = (RangeEnum)param.getAnnotation(RangeEnum.class);
            if (rangeEnum != null) {
                Class<Enum<?>> enumClass = rangeEnum.value();
                String className = enumClass.getName().replace('$', '.');
                paramMetaData.put(param.getName(), className + ".values()");
                continue;
            }
            String msg = "The parameter, " + param.getName() + ", on method, " + method.getName() + ", must have it's range specified" + "by a RangeField or RangeEnum annotation.";
            this.logger.log(TreeLogger.ERROR, msg, null);
            throw new UnableToCompleteException();
        }
        return paramMetaData;
    }

    private synchronized long getDefaultTimeout() throws UnableToCompleteException {
        if (defaultTimeout != -1L) {
            return defaultTimeout;
        }
        Method m = null;
        try {
            m = IterationTimeLimit.class.getDeclaredMethod("value", new Class[0]);
            defaultTimeout = (Long)m.getDefaultValue();
        }
        catch (Exception e) {
            this.logger.log(TreeLogger.ERROR, "Unable to retrieve the default benchmark time limit", (Throwable)e);
            throw new UnableToCompleteException();
        }
        return defaultTimeout;
    }

    private void implementParameterizedTestMethods() throws UnableToCompleteException {
        Map<String, JMethod> parameterizedMethods = BenchmarkGenerator.getParameterizedTestMethods(this.getRequestedClass(), this.logger);
        SourceWriter sw = this.getSourceWriter();
        JClassType type = this.getRequestedClass();
        for (Map.Entry<String, JMethod> entry : parameterizedMethods.entrySet()) {
            int i;
            String name = entry.getKey();
            JMethod method = entry.getValue();
            JMethod beginMethod = BenchmarkGenerator.getBeginMethod(type, method);
            JMethod endMethod = BenchmarkGenerator.getEndMethod(type, method);
            sw.println("public void " + name + "() {");
            sw.indent();
            sw.println("  privateDelayTestFinish( 2000 );");
            sw.println();
            MutableLong bound = new MutableLong();
            Map<String, String> metaDataByParams = this.getAnnotationMetaData(method, bound);
            this.validateParams(method, metaDataByParams);
            JParameter[] methodParams = method.getParameters();
            ArrayList<String> paramNames = new ArrayList<String>(methodParams.length);
            for (i = 0; i < methodParams.length; ++i) {
                paramNames.add(methodParams[i].getName());
            }
            sw.print("final java.util.List<Iterable<?>> iterables = java.util.Arrays.asList( new Iterable<?>[] { ");
            for (i = 0; i < paramNames.size(); ++i) {
                String paramName = (String)paramNames.get(i);
                sw.print(ITERABLE_ADAPTER_CLASS + ".toIterable(" + metaDataByParams.get(paramName) + ")");
                if (i != paramNames.size() - 1) {
                    sw.print(",");
                } else {
                    sw.println("} );");
                }
                sw.print(" ");
            }
            sw.println("final " + PERMUTATION_ITERATOR_CLASS + " permutationIt = new " + PERMUTATION_ITERATOR_CLASS + "(iterables);\n" + DeferredCommand.class.getName() + ".addCommand( new " + IncrementalCommand.class.getName() + "() {\n" + "  public boolean execute() {\n" + "    privateDelayTestFinish( 10000 );\n" + "    if ( permutationIt.hasNext() ) {\n" + "      " + PERMUTATION_ITERATOR_CLASS + ".Permutation permutation = permutationIt.next();\n");
            for (i = 0; i < methodParams.length; ++i) {
                JParameter methodParam = methodParams[i];
                String typeName = methodParam.getType().getQualifiedSourceName();
                String paramName = (String)paramNames.get(i);
                sw.println("      " + typeName + " " + paramName + " = (" + typeName + ") permutation.getValues().get(" + i + ");");
            }
            String setupTimingName = "__setupTiming";
            String testTimingName = "__testTiming";
            sw.println("double __setupTiming = 0;");
            sw.println("double __testTiming = 0;");
            Statements setupBench = this.genBenchTarget(beginMethod, endMethod, paramNames, (Statements)new Statement((Expression)new MethodCall(EMPTY_FUNC, null)));
            Statements testBench = this.genBenchTarget(beginMethod, endMethod, paramNames, (Statements)new Statement((Expression)new MethodCall(method.getName(), paramNames)));
            StringBuffer recordResultsCode = new StringBuffer(BENCHMARK_RESULTS_CLASS + " results = __getOrCreateTestResult();\n" + TRIAL_CLASS + " trial = new " + TRIAL_CLASS + "();\n" + "trial.setRunTimeMillis( " + "__testTiming" + " - " + "__setupTiming" + " );\n" + "java.util.Map<String, String> variables = trial.getVariables();\n");
            for (String paramName : paramNames) {
                recordResultsCode.append("variables.put( \"").append(paramName).append("\", ").append(paramName).append(".toString() );\n");
            }
            recordResultsCode.append("results.getTrials().add( trial )");
            Statement recordCode = new Statement(recordResultsCode.toString());
            Statement breakCode = new Statement("  permutationIt.skipCurrentRange()");
            setupBench = this.benchmark(setupBench, "__setupTiming", 0L, null, (Statements)breakCode);
            testBench = this.benchmark(testBench, "__testTiming", bound.value, (Statements)recordCode, (Statements)breakCode);
            StatementsList testAndSetup = new StatementsList();
            testAndSetup.getStatements().addAll(setupBench.getStatements());
            testAndSetup.getStatements().addAll(testBench.getStatements());
            sw.println(testAndSetup.toString());
            sw.println("      return true;\n    }\n    privateFinishTest();\n    return false;\n  }\n} );\n");
            sw.outdent();
            sw.println("}");
        }
    }

    private void implementZeroArgTestMethods() throws UnableToCompleteException {
        Map<String, JMethod> zeroArgMethods = BenchmarkGenerator.getNotOverloadedTestMethods(this.getRequestedClass());
        SourceWriter sw = this.getSourceWriter();
        JClassType type = this.getRequestedClass();
        for (Map.Entry<String, JMethod> entry : zeroArgMethods.entrySet()) {
            String name = entry.getKey();
            JMethod method = entry.getValue();
            JMethod beginMethod = BenchmarkGenerator.getBeginMethod(type, method);
            JMethod endMethod = BenchmarkGenerator.getEndMethod(type, method);
            sw.println("public void " + name + "() {");
            sw.indent();
            String setupTimingName = "__setupTiming";
            String testTimingName = "__testTiming";
            sw.println("double __setupTiming = 0;");
            sw.println("double __testTiming = 0;");
            Statements setupBench = this.genBenchTarget(beginMethod, endMethod, Collections.<String>emptyList(), (Statements)new Statement((Expression)new MethodCall(EMPTY_FUNC, null)));
            StatementsList testStatements = new StatementsList();
            testStatements.getStatements().add(new Statement((Expression)new MethodCall("super." + method.getName(), null)));
            Statements testBench = this.genBenchTarget(beginMethod, endMethod, Collections.<String>emptyList(), (Statements)testStatements);
            String recordResultsCode = BENCHMARK_RESULTS_CLASS + " results = __getOrCreateTestResult();\n" + TRIAL_CLASS + " trial = new " + TRIAL_CLASS + "();\n" + "trial.setRunTimeMillis( " + "__testTiming" + " - " + "__setupTiming" + " );\n" + "results.getTrials().add( trial )";
            Statement breakCode = new Statement("  break __escapeLoop");
            setupBench = this.benchmark(setupBench, "__setupTiming", 0L, null, (Statements)breakCode);
            testBench = this.benchmark(testBench, "__testTiming", this.getDefaultTimeout(), (Statements)new Statement(recordResultsCode), (Statements)breakCode);
            ForLoop loop = (ForLoop)testBench.getStatements().get(0);
            loop.setLabel(ESCAPE_LOOP);
            sw.println(setupBench.toString());
            sw.println(testBench.toString());
            sw.outdent();
            sw.println("}");
        }
    }

    private void validateParams(JMethod method, Map<String, String> params) throws UnableToCompleteException {
        JParameter[] methodParams;
        for (JParameter methodParam : methodParams = method.getParameters()) {
            String paramName = methodParam.getName();
            String paramValue = params.get(paramName);
            if (paramValue != null) continue;
            String msg = "Could not find the meta data attribute gwt.benchmark.param for the parameter " + paramName + " on method " + method.getName();
            this.logger.log(TreeLogger.ERROR, msg, null);
            throw new UnableToCompleteException();
        }
    }

    private static class MutableLong {
        long value;

        private MutableLong() {
        }
    }
}

