/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.rebind;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.dev.util.Util;
import com.google.gwt.dev.util.log.PrintWriterTreeLogger;
import com.google.gwt.i18n.client.Localizable;
import com.google.gwt.user.rebind.ClassSourceFileComposerFactory;
import com.google.gwt.user.rebind.SourceWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tapestry.util.text.LocalizedProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLocalizableInterfaceCreator {
    private static final char[] NIBBLE_TO_HEX_CHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    protected SourceWriter composer;
    private List<ResourceKeyFormatter> formatters = new ArrayList<ResourceKeyFormatter>();
    private File resourceFile;
    private File sourceFile;
    private PrintWriter writer;

    private static boolean needsUnicodeEscape(char ch) {
        if (ch == ' ') {
            return false;
        }
        switch (Character.getType(ch)) {
            case 0: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                return true;
            }
        }
        return false;
    }

    private static void unicodeEscape(char ch, StringBuilder buf) {
        buf.append('\\');
        buf.append('u');
        buf.append(NIBBLE_TO_HEX_CHAR[ch >> 12 & 0xF]);
        buf.append(NIBBLE_TO_HEX_CHAR[ch >> 8 & 0xF]);
        buf.append(NIBBLE_TO_HEX_CHAR[ch >> 4 & 0xF]);
        buf.append(NIBBLE_TO_HEX_CHAR[ch & 0xF]);
    }

    public AbstractLocalizableInterfaceCreator(String className, String packageName, File resourceBundle, File targetLocation, Class<? extends Localizable> interfaceClass) throws IOException {
        this.setup(packageName, className, resourceBundle, targetLocation, interfaceClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate() throws FileNotFoundException, IOException {
        try {
            try {
                this.generateFromPropertiesFile();
            }
            finally {
                this.writer.close();
            }
        }
        catch (IOException e) {
            this.sourceFile.delete();
            throw e;
        }
        catch (RuntimeException e) {
            this.sourceFile.delete();
            throw e;
        }
    }

    public void genSimpleMethodDecl(String key, String defaultValue) {
        this.genMethodDecl("String", defaultValue, key);
    }

    protected abstract void genMethodArgs(String var1);

    protected abstract void genValueAnnotation(String var1);

    protected abstract String javaDocComment(String var1);

    protected String makeJavaString(String value) {
        StringBuilder buf = new StringBuilder();
        buf.append('\"');
        block5: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\r': {
                    buf.append("\\r");
                    continue block5;
                }
                case '\n': {
                    buf.append("\\n");
                    continue block5;
                }
                case '\"': {
                    buf.append("\\\"");
                    continue block5;
                }
                default: {
                    if (AbstractLocalizableInterfaceCreator.needsUnicodeEscape(c)) {
                        AbstractLocalizableInterfaceCreator.unicodeEscape(c, buf);
                        continue block5;
                    }
                    buf.append(c);
                }
            }
        }
        buf.append('\"');
        return buf.toString();
    }

    void generateFromPropertiesFile() throws IOException {
        FileInputStream propStream = new FileInputStream(this.resourceFile);
        LocalizedProperties p = new LocalizedProperties();
        p.load((InputStream)propStream, Util.DEFAULT_ENCODING);
        this.addFormatters();
        Set keySet = p.getPropertyMap().keySet();
        Object[] keys = keySet.toArray(new String[keySet.size()]);
        Arrays.sort(keys);
        if (keys.length == 0) {
            throw new IllegalStateException("File '" + this.resourceFile + "' cannot be used to generate message classes, as it has no key/value pairs defined.");
        }
        for (Object key : keys) {
            String value = p.getProperty((String)key);
            this.genSimpleMethodDecl((String)key, value);
        }
        this.composer.commit((TreeLogger)new PrintWriterTreeLogger());
    }

    private void addFormatters() {
        this.formatters.add(new ReplaceBadChars());
        this.formatters.add(new RenameDuplicates());
    }

    private String formatKey(String key) {
        for (ResourceKeyFormatter formatter : this.formatters) {
            key = formatter.format(key);
        }
        return key;
    }

    private void genMethodDecl(String type, String defaultValue, String key) {
        this.composer.beginJavaDocComment();
        String escaped = this.makeJavaString(defaultValue);
        this.composer.println("Translated " + escaped + ".\n");
        this.composer.print("@return translated " + escaped);
        this.composer.endJavaDocComment();
        this.genValueAnnotation(defaultValue);
        this.composer.println("@Key(" + this.makeJavaString(key) + ")");
        String methodName = this.formatKey(key);
        this.composer.print(type + " " + methodName);
        this.composer.print("(");
        this.genMethodArgs(defaultValue);
        this.composer.print(");\n");
    }

    private void setup(String packageName, String className, File resourceBundle, File targetLocation, Class<? extends Localizable> interfaceClass) throws IOException {
        ClassSourceFileComposerFactory factory = new ClassSourceFileComposerFactory(packageName, className);
        factory.makeInterface();
        factory.setJavaDocCommentForClass(this.javaDocComment(resourceBundle.getCanonicalPath().replace(File.separatorChar, '/')));
        factory.addImplementedInterface(interfaceClass.getName());
        FileOutputStream file = new FileOutputStream(targetLocation);
        OutputStreamWriter underlying = new OutputStreamWriter((OutputStream)file, Util.DEFAULT_ENCODING);
        this.writer = new PrintWriter(underlying);
        this.composer = factory.createSourceWriter(this.writer);
        this.resourceFile = resourceBundle;
        this.sourceFile = targetLocation;
    }

    private static class RenameDuplicates
    extends ResourceKeyFormatter {
        private Set<String> methodNames = new HashSet<String>();

        private RenameDuplicates() {
        }

        public String format(String key) {
            while (this.methodNames.contains(key)) {
                key = key + "_dup";
            }
            this.methodNames.add(key);
            return key;
        }
    }

    private static class ReplaceBadChars
    extends ResourceKeyFormatter {
        private ReplaceBadChars() {
        }

        public String format(String key) {
            StringBuilder buf = new StringBuilder();
            int keyLen = key == null ? 0 : key.length();
            int i = 0;
            while (i < keyLen) {
                int codePoint = key.codePointAt(i);
                if (i == 0 ? Character.isJavaIdentifierStart(codePoint) : Character.isJavaIdentifierPart(codePoint)) {
                    buf.appendCodePoint(codePoint);
                } else {
                    buf.append('_');
                }
                i = key.offsetByCodePoints(i, 1);
            }
            if (buf.length() == 0) {
                buf.append('_');
            }
            return buf.toString();
        }
    }

    private static abstract class ResourceKeyFormatter {
        private ResourceKeyFormatter() {
        }

        public abstract String format(String var1);
    }
}

