/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.rebind;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.typeinfo.JArrayType;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.core.ext.typeinfo.JParameter;
import com.google.gwt.core.ext.typeinfo.JParameterizedType;
import com.google.gwt.core.ext.typeinfo.JPrimitiveType;
import com.google.gwt.core.ext.typeinfo.JRawType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.i18n.client.Constants;
import com.google.gwt.i18n.client.LocalizableResource;
import com.google.gwt.i18n.client.Messages;
import com.google.gwt.i18n.client.PluralRule;
import com.google.gwt.i18n.rebind.AbstractResource;
import com.google.gwt.i18n.rebind.AnnotationUtil;
import com.google.gwt.i18n.rebind.LocaleUtils;
import com.google.gwt.i18n.rebind.keygen.KeyGenerator;
import com.google.gwt.i18n.rebind.keygen.MethodNameKeyGenerator;
import com.google.gwt.i18n.shared.GwtLocale;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationsResource
extends AbstractResource {
    private Map<String, MethodEntry> map;

    public static String getKey(TreeLogger logger, KeyGenerator keyGenerator, JMethod method, boolean isConstants) {
        String text;
        LocalizableResource.Key key = (LocalizableResource.Key)method.getAnnotation(LocalizableResource.Key.class);
        if (key != null) {
            return key.value();
        }
        try {
            text = AnnotationsResource.getTextString(method, null, isConstants);
        }
        catch (AnnotationsError e) {
            return null;
        }
        String meaningString = null;
        LocalizableResource.Meaning meaning = (LocalizableResource.Meaning)method.getAnnotation(LocalizableResource.Meaning.class);
        if (meaning != null) {
            meaningString = meaning.value();
        }
        if (keyGenerator == null) {
            return null;
        }
        String keyStr = keyGenerator.generateKey(method.getEnclosingType().getQualifiedSourceName(), method.getName(), text, meaningString);
        if (keyStr == null) {
            if (text == null) {
                logger.log(TreeLogger.ERROR, "Key generator " + keyGenerator.getClass().getName() + " requires the default value be specified in an annotation for method " + method.getName(), null);
            } else {
                logger.log(TreeLogger.ERROR, "Key generator " + keyGenerator.getClass().getName() + " was unable to compute a key value for method " + method.getName(), null);
            }
        }
        return keyStr;
    }

    public static KeyGenerator getKeyGenerator(JClassType targetClass) throws AnnotationsError {
        LocalizableResource.GenerateKeys generator = AnnotationUtil.getClassAnnotation(targetClass, LocalizableResource.GenerateKeys.class);
        if (generator != null) {
            String className = generator.value();
            try {
                Class<KeyGenerator> keyGeneratorClass = Class.forName(className, false, KeyGenerator.class.getClassLoader()).asSubclass(KeyGenerator.class);
                return keyGeneratorClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new AnnotationsError("@GenerateKeys: unable to instantiate " + className);
            }
            catch (IllegalAccessException e) {
                throw new AnnotationsError("@GenerateKeys: unable to instantiate " + className);
            }
            catch (ClassNotFoundException e) {
                throw new AnnotationsError("Invalid class specified to @GenerateKeys: " + className);
            }
        }
        return new MethodNameKeyGenerator();
    }

    private static String getTextString(JMethod method, Map<String, MethodEntry> map, boolean isConstants) throws AnnotationsError {
        JPrimitiveType primType;
        JType returnType = method.getReturnType();
        Messages.DefaultMessage defaultText = (Messages.DefaultMessage)method.getAnnotation(Messages.DefaultMessage.class);
        Constants.DefaultStringValue stringValue = (Constants.DefaultStringValue)method.getAnnotation(Constants.DefaultStringValue.class);
        Constants.DefaultStringArrayValue stringArrayValue = (Constants.DefaultStringArrayValue)method.getAnnotation(Constants.DefaultStringArrayValue.class);
        Constants.DefaultStringMapValue stringMapValue = (Constants.DefaultStringMapValue)method.getAnnotation(Constants.DefaultStringMapValue.class);
        Constants.DefaultIntValue intValue = (Constants.DefaultIntValue)method.getAnnotation(Constants.DefaultIntValue.class);
        Constants.DefaultFloatValue floatValue = (Constants.DefaultFloatValue)method.getAnnotation(Constants.DefaultFloatValue.class);
        Constants.DefaultDoubleValue doubleValue = (Constants.DefaultDoubleValue)method.getAnnotation(Constants.DefaultDoubleValue.class);
        Constants.DefaultBooleanValue booleanValue = (Constants.DefaultBooleanValue)method.getAnnotation(Constants.DefaultBooleanValue.class);
        int constantsCount = 0;
        if (stringValue != null) {
            ++constantsCount;
            if (!returnType.getQualifiedSourceName().equals("java.lang.String")) {
                throw new AnnotationsError("@DefaultStringValue can only be used with a method returning String");
            }
        }
        if (stringArrayValue != null) {
            ++constantsCount;
            JArrayType arrayType = returnType.isArray();
            if (arrayType == null || !arrayType.getComponentType().getQualifiedSourceName().equals("java.lang.String")) {
                throw new AnnotationsError("@DefaultStringArrayValue can only be used with a method returning String[]");
            }
        }
        if (stringMapValue != null) {
            ++constantsCount;
            JRawType rawType = returnType.getErasedType().isRawType();
            boolean error = false;
            if (rawType == null || !rawType.getQualifiedSourceName().equals("java.util.Map")) {
                error = true;
            } else {
                JClassType[] args;
                JParameterizedType paramType = returnType.isParameterized();
                if (!(paramType == null || (args = paramType.getTypeArgs()).length == 2 && args[0].getQualifiedSourceName().equals("java.lang.String") && args[1].getQualifiedSourceName().equals("java.lang.String"))) {
                    error = true;
                }
            }
            if (error) {
                throw new AnnotationsError("@DefaultStringMapValue can only be used with a method returning Map or Map<String,String>");
            }
        }
        if (intValue != null) {
            ++constantsCount;
            primType = returnType.isPrimitive();
            if (primType != JPrimitiveType.INT) {
                throw new AnnotationsError("@DefaultIntValue can only be used with a method returning int");
            }
        }
        if (floatValue != null) {
            ++constantsCount;
            primType = returnType.isPrimitive();
            if (primType != JPrimitiveType.FLOAT) {
                throw new AnnotationsError("@DefaultFloatValue can only be used with a method returning float");
            }
        }
        if (doubleValue != null) {
            ++constantsCount;
            primType = returnType.isPrimitive();
            if (primType != JPrimitiveType.DOUBLE) {
                throw new AnnotationsError("@DefaultDoubleValue can only be used with a method returning double");
            }
        }
        if (booleanValue != null) {
            ++constantsCount;
            primType = returnType.isPrimitive();
            if (primType != JPrimitiveType.BOOLEAN) {
                throw new AnnotationsError("@DefaultBooleanValue can only be used with a method returning boolean");
            }
        }
        if (!isConstants) {
            if (constantsCount > 0) {
                throw new AnnotationsError("@Default*Value is not permitted on a Messages interface; see @DefaultText");
            }
            if (defaultText != null) {
                return defaultText.value();
            }
        } else {
            boolean firstString;
            StringBuilder buf;
            if (defaultText != null) {
                throw new AnnotationsError("@DefaultText is not permitted on a Constants interface; see @Default*Value");
            }
            if (constantsCount > 1) {
                throw new AnnotationsError("No more than one @Default*Value annotation may be used on a method");
            }
            if (stringValue != null) {
                return stringValue.value();
            }
            if (intValue != null) {
                return Integer.toString(intValue.value());
            }
            if (floatValue != null) {
                return Float.toString(floatValue.value());
            }
            if (doubleValue != null) {
                return Double.toString(doubleValue.value());
            }
            if (booleanValue != null) {
                return Boolean.toString(booleanValue.value());
            }
            if (stringArrayValue != null) {
                buf = new StringBuilder();
                firstString = true;
                for (String str : stringArrayValue.value()) {
                    str = str.replace("\\", "\\\\");
                    str = str.replace(",", "\\,");
                    if (!firstString) {
                        buf.append(',');
                    } else {
                        firstString = false;
                    }
                    buf.append(str);
                }
                return buf.toString();
            }
            if (stringMapValue != null) {
                buf = new StringBuilder();
                firstString = true;
                String[] entries = stringMapValue.value();
                if ((entries.length & 1) != 0) {
                    throw new AnnotationsError("Odd number of strings supplied to @DefaultStringMapValue");
                }
                for (int i = 0; i < entries.length; i += 2) {
                    String key = entries[i];
                    String value = entries[i + 1];
                    if (map != null) {
                        MethodEntry entry = new MethodEntry(value, null);
                        map.put(key, entry);
                    }
                    key = key.replace("\\", "\\\\");
                    key = key.replace(",", "\\,");
                    if (!firstString) {
                        buf.append(',');
                    } else {
                        firstString = false;
                    }
                    buf.append(key);
                }
                return buf.toString();
            }
        }
        return null;
    }

    public AnnotationsResource(TreeLogger logger, JClassType clazz, GwtLocale locale, boolean isConstants) throws AnnotationsError {
        super(locale);
        LocalizableResource.DefaultLocale defLocaleAnnot;
        KeyGenerator keyGenerator = AnnotationsResource.getKeyGenerator(clazz);
        this.map = new HashMap<String, MethodEntry>();
        this.setPath(clazz.getQualifiedSourceName());
        String defLocaleValue = null;
        String className = clazz.getSimpleSourceName();
        int underscore = className.indexOf(95);
        if (underscore >= 0) {
            defLocaleValue = className.substring(underscore + 1);
        }
        if ((defLocaleAnnot = AnnotationUtil.getClassAnnotation(clazz, LocalizableResource.DefaultLocale.class)) != null) {
            defLocaleValue = defLocaleAnnot.value();
        }
        GwtLocale defLocale = LocaleUtils.getLocaleFactory().fromString(defLocaleValue);
        if (!locale.isDefault() && !locale.equals(defLocale)) {
            logger.log(TreeLogger.WARN, "Default locale " + defLocale + " on " + clazz.getQualifiedSourceName() + " doesn't match " + locale);
            return;
        }
        this.matchLocale = defLocale;
        for (JMethod method : clazz.getMethods()) {
            Messages.PluralText pluralText;
            String textString;
            String meaningString = null;
            LocalizableResource.Meaning meaning = (LocalizableResource.Meaning)method.getAnnotation(LocalizableResource.Meaning.class);
            if (meaning != null) {
                meaningString = meaning.value();
            }
            if ((textString = AnnotationsResource.getTextString(method, this.map, isConstants)) == null) continue;
            String key = null;
            LocalizableResource.Key keyAnnot = (LocalizableResource.Key)method.getAnnotation(LocalizableResource.Key.class);
            key = keyAnnot != null ? keyAnnot.value() : keyGenerator.generateKey(method.getEnclosingType().getQualifiedSourceName(), method.getName(), textString, meaningString);
            if (key == null) {
                throw new AnnotationsError("Could not compute key for " + method.getEnclosingType().getQualifiedSourceName() + "." + method.getName());
            }
            MethodEntry entry = new MethodEntry(textString, meaningString);
            this.map.put(key, entry);
            LocalizableResource.Description description = (LocalizableResource.Description)method.getAnnotation(LocalizableResource.Description.class);
            if (description != null) {
                entry.description = description.value();
            }
            if ((pluralText = (Messages.PluralText)method.getAnnotation(Messages.PluralText.class)) != null) {
                String[] pluralForms = pluralText.value();
                if ((pluralForms.length & 1) != 0) {
                    throw new AnnotationsError("Odd number of strings supplied to @PluralText: must be pairs of form names and strings");
                }
                int i = 0;
                while (i + 1 < pluralForms.length) {
                    entry.addPluralText(pluralForms[i], pluralForms[i + 1]);
                    i += 2;
                }
            }
            for (JParameter param : method.getParameters()) {
                Messages.Example example;
                Messages.PluralCount pluralCount;
                ArgumentInfo argInfo = entry.addArgument(param.getName());
                Messages.Optional optional = (Messages.Optional)param.getAnnotation(Messages.Optional.class);
                if (optional != null) {
                    argInfo.optional = true;
                }
                if ((pluralCount = (Messages.PluralCount)param.getAnnotation(Messages.PluralCount.class)) != null) {
                    argInfo.isPluralCount = true;
                }
                if ((example = (Messages.Example)param.getAnnotation(Messages.Example.class)) == null) continue;
                argInfo.example = example.value();
            }
        }
    }

    @Override
    public void addToKeySet(Set<String> s) {
        s.addAll(this.map.keySet());
    }

    public Iterable<ArgumentInfo> argumentsIterator(String key) {
        MethodEntry entry = this.map.get(key);
        return entry != null ? entry.arguments : null;
    }

    public String getDescription(String key) {
        MethodEntry entry = this.map.get(key);
        return entry == null ? null : entry.description;
    }

    @Override
    public Collection<String> getExtensions(String key) {
        MethodEntry entry = this.map.get(key);
        return entry == null ? new ArrayList() : entry.pluralText.keySet();
    }

    public String getMeaning(String key) {
        MethodEntry entry = this.map.get(key);
        return entry == null ? null : entry.meaning;
    }

    @Override
    public String getStringExt(String key, String extension) {
        MethodEntry entry = this.map.get(key);
        if (entry == null) {
            return null;
        }
        if (extension != null) {
            return entry.pluralText.get(extension);
        }
        return entry.text;
    }

    @Override
    public boolean notEmpty() {
        return !this.map.isEmpty();
    }

    @Override
    public String toString() {
        return "Annotations from class " + this.getPath() + " @" + this.getMatchLocale();
    }

    public static class AnnotationsError
    extends Exception {
        public AnnotationsError(String msg) {
            super(msg);
        }
    }

    public static class ArgumentInfo {
        public String example;
        public boolean isPluralCount;
        public String name;
        public boolean optional;
        public Class<? extends PluralRule> pluralRuleClass;

        public ArgumentInfo(String name) {
            this.name = name;
        }
    }

    private static class MethodEntry {
        private static final String DETAILS_PREFIX = " (";
        private static final String DETAILS_SEPARATOR = ", ";
        public ArrayList<ArgumentInfo> arguments;
        public String description;
        public String meaning;
        public Map<String, String> pluralText;
        public String text;

        public MethodEntry(String text, String meaning) {
            this.text = text;
            this.meaning = meaning;
            this.pluralText = new HashMap<String, String>();
            this.arguments = new ArrayList();
        }

        public ArgumentInfo addArgument(String argName) {
            ArgumentInfo argInfo = new ArgumentInfo(argName);
            this.arguments.add(argInfo);
            return argInfo;
        }

        public void addPluralText(String form, String pluralFormText) {
            this.pluralText.put(form, pluralFormText);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(this.text);
            String prefix = DETAILS_PREFIX;
            if (this.meaning != null) {
                buf.append(prefix).append("meaning=").append(this.meaning);
                prefix = DETAILS_SEPARATOR;
            }
            if (this.description != null) {
                buf.append(prefix).append("desc=").append(this.description);
                prefix = DETAILS_SEPARATOR;
            }
            if (DETAILS_SEPARATOR == prefix) {
                buf.append(')');
            }
            return buf.toString();
        }
    }
}

