/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.rebind;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JArrayType;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.core.ext.typeinfo.JParameter;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.core.ext.typeinfo.TypeOracleException;
import com.google.gwt.i18n.rebind.AbstractResource;
import com.google.gwt.i18n.rebind.ConstantsImplCreator;
import com.google.gwt.i18n.rebind.LookupMethodCreator;
import com.google.gwt.i18n.shared.GwtLocale;
import com.google.gwt.user.rebind.AbstractMethodCreator;
import com.google.gwt.user.rebind.SourceWriter;
import java.util.HashMap;
import java.util.Map;

class ConstantsWithLookupImplCreator
extends ConstantsImplCreator {
    final JMethod[] allInterfaceMethods;
    private final Map<String, AbstractMethodCreator> namesToMethodCreators = new HashMap<String, AbstractMethodCreator>();

    ConstantsWithLookupImplCreator(TreeLogger logger, SourceWriter writer, JClassType localizableClass, AbstractResource.ResourceList resourceList, TypeOracle oracle) throws UnableToCompleteException {
        super(logger, writer, localizableClass, resourceList, oracle);
        try {
            JType booleanType = oracle.parse(Boolean.TYPE.getName());
            LookupMethodCreator booleanMethod = new LookupMethodCreator(this, booleanType){

                public void printReturnTarget() {
                    this.println("return target.booleanValue();");
                }

                public String returnTemplate() {
                    return "boolean answer = {0}();\ncache.put(\"{0}\",new Boolean(answer));\nreturn answer;";
                }
            };
            this.namesToMethodCreators.put("getBoolean", booleanMethod);
            JType doubleType = oracle.parse(Double.TYPE.getName());
            LookupMethodCreator doubleMethod = new LookupMethodCreator(this, doubleType){

                public void printReturnTarget() {
                    this.println("return target.doubleValue();");
                }

                public String returnTemplate() {
                    return "double answer = {0}();\ncache.put(\"{0}\",new Double(answer));\nreturn answer;";
                }
            };
            this.namesToMethodCreators.put("getDouble", doubleMethod);
            JType intType = oracle.parse(Integer.TYPE.getName());
            LookupMethodCreator intMethod = new LookupMethodCreator(this, intType){

                public void printReturnTarget() {
                    this.println("return target.intValue();");
                }

                public String returnTemplate() {
                    return "int answer = {0}();\ncache.put(\"{0}\",new Integer(answer));\nreturn answer;";
                }
            };
            this.namesToMethodCreators.put("getInt", intMethod);
            JType floatType = oracle.parse(Float.TYPE.getName());
            LookupMethodCreator floatMethod = new LookupMethodCreator(this, floatType){

                public String returnTemplate() {
                    String val = "float answer = {0}();\ncache.put(\"{0}\", new Float(answer));\nreturn answer;";
                    return val;
                }

                protected void printReturnTarget() {
                    this.println("return target.floatValue();");
                }
            };
            this.namesToMethodCreators.put("getFloat", floatMethod);
            JType mapType = oracle.parse(Map.class.getName()).getErasedType();
            this.namesToMethodCreators.put("getMap", new LookupMethodCreator(this, mapType){

                public String getReturnTypeName() {
                    return "java.util.Map<java.lang.String, java.lang.String>";
                }
            });
            JType stringType = oracle.parse(String.class.getName());
            LookupMethodCreator stringMethod = new LookupMethodCreator(this, stringType){

                public String returnTemplate() {
                    return "String answer = {0}();\ncache.put(\"{0}\",answer);\nreturn answer;";
                }
            };
            this.namesToMethodCreators.put("getString", stringMethod);
            JArrayType stringArray = oracle.getArrayType(stringType);
            this.namesToMethodCreators.put("getStringArray", new LookupMethodCreator(this, (JType)stringArray));
            this.setNeedCache(true);
            this.allInterfaceMethods = ConstantsWithLookupImplCreator.getAllInterfaceMethods(localizableClass);
        }
        catch (TypeOracleException e) {
            throw ConstantsWithLookupImplCreator.error(logger, e);
        }
    }

    protected void emitMethodBody(TreeLogger logger, JMethod method, GwtLocale locale) throws UnableToCompleteException {
        String name;
        AbstractMethodCreator c;
        this.checkMethod(logger, method);
        if (method.getParameters().length == 1 && (c = this.namesToMethodCreators.get(name = method.getName())) != null) {
            c.createMethodFor(logger, method, name, null, locale);
            return;
        }
        super.emitMethodBody(logger, method, locale);
    }

    private void checkMethod(TreeLogger logger, JMethod method) throws UnableToCompleteException {
        if (this.namesToMethodCreators.get(method.getName()) != null) {
            JParameter[] params = method.getParameters();
            if (params.length == 0) {
                this.checkConstantMethod(logger, method);
            } else {
                if (params.length != 1 || !params[0].getType().getQualifiedSourceName().equals("java.lang.String")) {
                    throw ConstantsWithLookupImplCreator.error(logger, method + " must have a single String argument.");
                }
                this.checkReturnType(logger, method);
            }
        } else {
            this.checkConstantMethod(logger, method);
        }
    }
}

