/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.rebind;

import com.google.gwt.core.ext.BadPropertyValueException;
import com.google.gwt.core.ext.Generator;
import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.PropertyOracle;
import com.google.gwt.core.ext.SelectionProperty;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.NotFoundException;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.i18n.client.Constants;
import com.google.gwt.i18n.client.ConstantsWithLookup;
import com.google.gwt.i18n.client.Messages;
import com.google.gwt.i18n.rebind.AbstractLocalizableImplCreator;
import com.google.gwt.i18n.rebind.ClearStaticData;
import com.google.gwt.i18n.rebind.LocaleUtils;
import com.google.gwt.i18n.rebind.LocalizableLinkageCreator;
import com.google.gwt.i18n.shared.GwtLocale;

public class LocalizableGenerator
extends Generator {
    public static final String GWT_KEY = "gwt.key";
    public static final String CONSTANTS_NAME = Constants.class.getName();
    public static final String CONSTANTS_WITH_LOOKUP_NAME = ConstantsWithLookup.class.getName();
    public static final String MESSAGES_NAME = Messages.class.getName();
    private static long lastReloadCount = -1L;
    private static final String PROP_LOCALE = "locale";
    private LocalizableLinkageCreator linkageCreator = new LocalizableLinkageCreator();

    public final String generate(TreeLogger logger, GeneratorContext context, String typeName) throws UnableToCompleteException {
        String locale;
        PropertyOracle propertyOracle = context.getPropertyOracle();
        try {
            SelectionProperty localeProp = propertyOracle.getSelectionProperty(logger, PROP_LOCALE);
            locale = localeProp.getCurrentValue();
        }
        catch (BadPropertyValueException e) {
            logger.log(TreeLogger.ERROR, "Could not parse specified locale", (Throwable)e);
            throw new UnableToCompleteException();
        }
        return this.generate(logger, context, typeName, locale);
    }

    public final String generate(TreeLogger logger, GeneratorContext context, String typeName, String localeName) throws UnableToCompleteException {
        JClassType targetClass;
        TypeOracle typeOracle = context.getTypeOracle();
        if (lastReloadCount != typeOracle.getReloadCount()) {
            ClearStaticData.clear();
            lastReloadCount = typeOracle.getReloadCount();
        }
        try {
            targetClass = typeOracle.getType(typeName);
        }
        catch (NotFoundException e) {
            logger.log(TreeLogger.ERROR, "No such type", (Throwable)e);
            throw new UnableToCompleteException();
        }
        GwtLocale locale = LocaleUtils.getLocaleFactory().fromString(localeName);
        String generatedClass = AbstractLocalizableImplCreator.generateConstantOrMessageClass(logger, context, locale, targetClass);
        if (generatedClass != null) {
            return generatedClass;
        }
        return this.linkageCreator.linkWithImplClass(logger, targetClass, locale);
    }
}

