/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.rebind;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.dev.resource.Resource;
import com.google.gwt.dev.util.collect.IdentityHashSet;
import com.google.gwt.i18n.client.LocalizableResource;
import com.google.gwt.i18n.rebind.AbstractResource;
import com.google.gwt.i18n.rebind.AnnotationUtil;
import com.google.gwt.i18n.rebind.AnnotationsResource;
import com.google.gwt.i18n.rebind.LocaleUtils;
import com.google.gwt.i18n.rebind.LocalizedPropertiesResource;
import com.google.gwt.i18n.shared.GwtLocale;
import com.google.gwt.i18n.shared.GwtLocaleFactory;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResourceFactory {
    public static final char LOCALE_SEPARATOR = '_';
    private static Map<ClassLocale, AbstractResource.ResourceList> cache = new HashMap<ClassLocale, AbstractResource.ResourceList>();
    private static List<ResourceFactory> loaders = new ArrayList<ResourceFactory>();

    public static synchronized void clearCache() {
        cache.clear();
    }

    public static synchronized AbstractResource.ResourceList getBundle(TreeLogger logger, JClassType topClass, GwtLocale bundleLocale, boolean isConstants, Map<String, Resource> resourceMap) {
        List<GwtLocale> locales = bundleLocale.getCompleteSearchList();
        ArrayList<JClassType> classes = new ArrayList<JClassType>();
        IdentityHashSet seenClasses = new IdentityHashSet();
        HashMap<ClassLocale, AnnotationsResource> annotations = new HashMap<ClassLocale, AnnotationsResource>();
        GwtLocaleFactory factory = LocaleUtils.getLocaleFactory();
        GwtLocale defaultLocale = factory.getDefault();
        ResourceFactory.walkInheritanceTree(logger, topClass, factory, defaultLocale, classes, annotations, (Set<JClassType>)seenClasses, isConstants);
        AbstractResource.ResourceList allResources = new AbstractResource.ResourceList();
        for (GwtLocale locale : locales) {
            for (JClassType clazz : classes) {
                AbstractResource.ResourceList resources;
                ClassLocale key = new ClassLocale(clazz, locale);
                if (cache.containsKey(key)) {
                    resources = cache.get(key);
                } else {
                    cache.put(key, null);
                    resources = new AbstractResource.ResourceList();
                    ResourceFactory.addFileResources(clazz, locale, resourceMap, resources);
                    AnnotationsResource annotationsResource = (AnnotationsResource)annotations.get(key);
                    if (annotationsResource != null) {
                        resources.add(annotationsResource);
                    }
                    cache.put(key, resources);
                }
                if (resources == null) continue;
                allResources.addAll(resources);
            }
        }
        String className = topClass.getQualifiedSourceName();
        TreeLogger branch = logger.branch(TreeLogger.SPAM, "Resource search order for " + className + ", locale " + bundleLocale);
        for (AbstractResource resource : allResources) {
            branch.log(TreeLogger.SPAM, resource.toString());
        }
        return allResources;
    }

    public static String getResourceName(JClassType targetClass) {
        String name = targetClass.getName();
        if (targetClass.isMemberType()) {
            name = name.replace('.', '$');
        }
        return name;
    }

    private static void addFileResources(JClassType clazz, GwtLocale locale, Map<String, Resource> resourceMap, AbstractResource.ResourceList resources) {
        String targetPath;
        String localizedPath = targetPath = clazz.getPackage().getName() + '.' + ResourceFactory.getResourceName(clazz);
        if (!locale.isDefault()) {
            localizedPath = targetPath + '_' + locale.getAsString();
        }
        String partialPath = localizedPath.replace('.', '/');
        for (int i = 0; i < loaders.size(); ++i) {
            ResourceFactory element = loaders.get(i);
            String ext = "." + element.getExt();
            String path = partialPath + ext;
            Resource resource = resourceMap.get(path);
            if (resource == null && partialPath.contains("$")) {
                path = partialPath.replace('$', '_') + ext;
                resource = resourceMap.get(path);
            }
            if (resource == null) continue;
            AbstractResource found = element.load(resource.openContents(), locale);
            found.setPath(path);
            resources.add(found);
        }
    }

    private static void walkInheritanceTree(TreeLogger logger, JClassType clazz, GwtLocaleFactory factory, GwtLocale defaultLocale, List<JClassType> classes, Map<ClassLocale, AnnotationsResource> annotations, Set<JClassType> seenClasses, boolean isConstants) {
        if (seenClasses.contains(clazz)) {
            return;
        }
        seenClasses.add(clazz);
        classes.add(clazz);
        try {
            AnnotationsResource resource = new AnnotationsResource(logger, clazz, defaultLocale, isConstants);
            if (resource.notEmpty()) {
                GwtLocale defLocale;
                LocalizableResource.DefaultLocale defLocaleAnnot;
                resource.setPath(clazz.getQualifiedSourceName());
                ClassLocale key = new ClassLocale(clazz, defaultLocale);
                annotations.put(key, resource);
                String defLocaleValue = null;
                String className = clazz.getSimpleSourceName();
                int underscore = className.indexOf(95);
                if (underscore >= 0) {
                    defLocaleValue = className.substring(underscore + 1);
                }
                if ((defLocaleAnnot = AnnotationUtil.getClassAnnotation(clazz, LocalizableResource.DefaultLocale.class)) != null) {
                    defLocaleValue = defLocaleAnnot.value();
                }
                if (!(defLocale = LocaleUtils.getLocaleFactory().fromString(defLocaleValue)).isDefault()) {
                    key = new ClassLocale(clazz, defLocale);
                    annotations.put(key, resource);
                }
            }
        }
        catch (AnnotationsResource.AnnotationsError e) {
            logger.log(TreeLogger.ERROR, e.getMessage(), (Throwable)e);
        }
        if (clazz.getSuperclass() != null) {
            ResourceFactory.walkInheritanceTree(logger, clazz.getSuperclass(), factory, defaultLocale, classes, annotations, seenClasses, isConstants);
        }
        for (JClassType intf : clazz.getImplementedInterfaces()) {
            ResourceFactory.walkInheritanceTree(logger, intf, factory, defaultLocale, classes, annotations, seenClasses, isConstants);
        }
    }

    abstract String getExt();

    abstract AbstractResource load(InputStream var1, GwtLocale var2);

    static {
        loaders.add(new LocalizedPropertiesResource.Factory());
    }

    private static class ClassLocale {
        private final JClassType clazz;
        private final GwtLocale locale;

        public ClassLocale(JClassType clazz, GwtLocale locale) {
            assert (clazz != null);
            assert (locale != null);
            this.clazz = clazz;
            this.locale = locale;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ClassLocale other = (ClassLocale)obj;
            return this.clazz.equals((Object)other.clazz) && this.locale.equals(other.locale);
        }

        public JClassType getJClass() {
            return this.clazz;
        }

        public GwtLocale getLocale() {
            return this.locale;
        }

        public int hashCode() {
            return this.clazz.hashCode() + this.locale.hashCode() * 53;
        }

        public String toString() {
            return this.clazz.getQualifiedSourceName() + "/" + ((Object)this.locale).toString();
        }
    }
}

