/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.junit;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.junit.JUnitShell;
import com.google.gwt.junit.RunStyle;
import com.google.gwt.junit.client.TimeoutException;
import com.google.gwt.junit.remote.BrowserManager;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.rmi.Naming;
import java.rmi.server.RMISocketFactory;
import java.util.HashSet;
import java.util.Set;

class RunStyleRemoteWeb
extends RunStyle {
    private static final int CONNECT_MS = 10000;
    private static final int PING_KEEPALIVE_MS = 5000;
    private static final int RESPONSE_TIMEOUT_MS = 10000;
    private Set<String> interruptedHosts;
    private RemoteBrowser[] remoteBrowsers;
    private final Object wasInterruptedLock = new Object();

    public RunStyleRemoteWeb(JUnitShell shell) {
        super(shell);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getInterruptedHosts() {
        Object object = this.wasInterruptedLock;
        synchronized (object) {
            if (this.interruptedHosts == null) {
                return null;
            }
            return this.interruptedHosts.toArray(new String[this.interruptedHosts.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int initialize(String args) {
        if (args == null || args.length() == 0) {
            this.getLogger().log(TreeLogger.ERROR, "RemoteWeb runstyle requires comma-separated RMI URLs");
            return -1;
        }
        String[] urls = args.split(",");
        try {
            RMISocketFactoryWithTimeouts.init();
        }
        catch (IOException e) {
            this.getLogger().log(TreeLogger.ERROR, "RemoteWeb: Error initializing RMISocketFactory", (Throwable)e);
            return -1;
        }
        int numClients = urls.length;
        BrowserManager[] browserManagers = new BrowserManager[numClients];
        for (int i = 0; i < numClients; ++i) {
            long callStart = System.currentTimeMillis();
            try {
                browserManagers[i] = (BrowserManager)Naming.lookup(urls[i]);
                continue;
            }
            catch (Exception e) {
                String message = "RemoteWeb: Error connecting to browser manager at " + urls[i];
                Throwable cause = e;
                if (e.getCause() instanceof SocketTimeoutException) {
                    long elapsed = System.currentTimeMillis() - callStart;
                    message = message + " - Timeout " + elapsed + "ms waiting to connect to browser manager.";
                    cause = e.getCause();
                }
                this.getLogger().log(TreeLogger.ERROR, message, cause);
                return -1;
            }
        }
        RunStyleRemoteWeb runStyleRemoteWeb = this;
        synchronized (runStyleRemoteWeb) {
            this.remoteBrowsers = new RemoteBrowser[browserManagers.length];
            for (int i = 0; i < browserManagers.length; ++i) {
                this.remoteBrowsers[i] = new RemoteBrowser(browserManagers[i], urls[i]);
            }
        }
        Runtime.getRuntime().addShutdownHook(new ShutdownCb());
        return numClients;
    }

    public synchronized void launchModule(String moduleName) throws UnableToCompleteException {
        String url = this.shell.getModuleUrl(moduleName);
        for (RemoteBrowser remoteBrowser : this.remoteBrowsers) {
            long callStart = System.currentTimeMillis();
            try {
                int remoteToken = remoteBrowser.getToken();
                BrowserManager mgr = remoteBrowser.getManager();
                if (remoteToken != 0) {
                    mgr.killBrowser(remoteToken);
                }
                remoteToken = mgr.launchNewBrowser(url, 5000L);
                remoteBrowser.setToken(remoteToken);
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (cause instanceof SocketTimeoutException) {
                    long elapsed = System.currentTimeMillis() - callStart;
                    this.getLogger().log(TreeLogger.ERROR, "Timeout: " + elapsed + "ms  launching remote browser at: " + remoteBrowser.getRmiUrl(), e.getCause());
                    throw new UnableToCompleteException();
                }
                this.getLogger().log(TreeLogger.ERROR, "Error launching remote browser at " + remoteBrowser.getRmiUrl(), (Throwable)e);
                throw new UnableToCompleteException();
            }
        }
        Thread keepAliveThread = new Thread(){

            public void run() {
                do {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (RunStyleRemoteWeb.this.doKeepAlives());
            }
        };
        keepAliveThread.setDaemon(true);
        keepAliveThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean doKeepAlives() {
        for (RemoteBrowser remoteBrowser : this.remoteBrowsers) {
            if (remoteBrowser.getToken() <= 0) continue;
            long callStart = System.currentTimeMillis();
            try {
                remoteBrowser.getManager().keepAlive(remoteBrowser.getToken(), 5000L);
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                String rmiUrl = remoteBrowser.getRmiUrl();
                if (cause instanceof SocketTimeoutException) {
                    long elapsed = System.currentTimeMillis() - callStart;
                    throw new TimeoutException("Timeout: " + elapsed + "ms  keeping alive remote browser at: " + rmiUrl, e.getCause());
                }
                if (e instanceof IllegalStateException) {
                    this.getLogger().log(TreeLogger.INFO, "Browser at: " + rmiUrl + " already exited.", (Throwable)e);
                } else {
                    this.getLogger().log(TreeLogger.ERROR, "Error keeping alive remote browser at " + rmiUrl, (Throwable)e);
                }
                remoteBrowser.setToken(0);
                Object object = this.wasInterruptedLock;
                synchronized (object) {
                    if (this.interruptedHosts == null) {
                        this.interruptedHosts = new HashSet<String>();
                    }
                    this.interruptedHosts.add(remoteBrowser.getRmiUrl());
                    break;
                }
            }
        }
        Object object = this.wasInterruptedLock;
        synchronized (object) {
            return this.interruptedHosts == null;
        }
    }

    static class RMISocketFactoryWithTimeouts
    extends RMISocketFactory {
        private static boolean initialized;

        RMISocketFactoryWithTimeouts() {
        }

        public static void init() throws IOException {
            if (!initialized) {
                RMISocketFactory.setSocketFactory(new RMISocketFactoryWithTimeouts());
                initialized = true;
            }
        }

        public ServerSocket createServerSocket(int port) throws IOException {
            return RMISocketFactory.getDefaultSocketFactory().createServerSocket(port);
        }

        public Socket createSocket(String host, int port) throws IOException {
            Socket socket = new Socket();
            socket.connect(new InetSocketAddress(host, port), 10000);
            socket.setSoTimeout(10000);
            return socket;
        }
    }

    private static class RemoteBrowser {
        private final BrowserManager manager;
        private final String rmiUrl;
        private int token;

        public RemoteBrowser(BrowserManager manager, String rmiUrl) {
            this.manager = manager;
            this.rmiUrl = rmiUrl;
        }

        public BrowserManager getManager() {
            return this.manager;
        }

        public String getRmiUrl() {
            return this.rmiUrl;
        }

        public int getToken() {
            return this.token;
        }

        public void setToken(int token) {
            this.token = token;
        }
    }

    private class ShutdownCb
    extends Thread {
        private ShutdownCb() {
        }

        public synchronized void run() {
            for (RemoteBrowser remoteBrowser : RunStyleRemoteWeb.this.remoteBrowsers) {
                int remoteToken = remoteBrowser.getToken();
                if (remoteToken <= 0) continue;
                try {
                    remoteBrowser.getManager().killBrowser(remoteToken);
                }
                catch (Exception e) {
                    System.err.println("Error killing remote browser during shutdown: " + remoteBrowser.getRmiUrl());
                    e.printStackTrace();
                }
                remoteBrowser.setToken(0);
            }
        }
    }
}

