/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.rebind;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.resources.client.DataResource;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.uibinder.rebind.FieldManager;
import com.google.gwt.uibinder.rebind.FieldWriter;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import com.google.gwt.uibinder.rebind.XMLElement;
import com.google.gwt.uibinder.rebind.messages.MessagesWriter;
import com.google.gwt.uibinder.rebind.model.ImplicitClientBundle;
import com.google.gwt.uibinder.rebind.model.ImplicitCssResource;
import com.google.gwt.uibinder.rebind.model.ImplicitDataResource;
import com.google.gwt.uibinder.rebind.model.ImplicitImageResource;
import com.google.gwt.uibinder.rebind.model.OwnerField;
import java.util.LinkedHashSet;

public class UiBinderParser {
    private static final String FLIP_RTL_ATTRIBUTE = "flipRtl";
    private static final String FIELD_ATTRIBUTE = "field";
    private static final String SOURCE_ATTRIBUTE = "src";
    private static final String REPEAT_STYLE_ATTRIBUTE = "repeatStyle";
    private static final String IMPORT_ATTRIBUTE = "import";
    private static final String TAG = "UiBinder";
    private final UiBinderWriter writer;
    private final TypeOracle oracle;
    private final MessagesWriter messagesWriter;
    private final FieldManager fieldManager;
    private final ImplicitClientBundle bundleClass;
    private final JClassType cssResourceType;
    private final JClassType imageResourceType;
    private final JClassType dataResourceType;

    public UiBinderParser(UiBinderWriter writer, MessagesWriter messagesWriter, FieldManager fieldManager, TypeOracle oracle, ImplicitClientBundle bundleClass) {
        this.writer = writer;
        this.oracle = oracle;
        this.messagesWriter = messagesWriter;
        this.fieldManager = fieldManager;
        this.bundleClass = bundleClass;
        this.cssResourceType = oracle.findType(CssResource.class.getCanonicalName());
        this.imageResourceType = oracle.findType(ImageResource.class.getCanonicalName());
        this.dataResourceType = oracle.findType(DataResource.class.getCanonicalName());
    }

    public String parse(XMLElement elem) throws UnableToCompleteException {
        if (!this.writer.isBinderElement(elem)) {
            this.writer.die("Bad prefix on <%s:%s>? The root element must be in xml namespace \"%s\" (usually with prefix \"ui:\"), but this has prefix \"%s\"", elem.getPrefix(), elem.getLocalName(), "urn:ui:com.google.gwt.uibinder", elem.getPrefix());
        }
        if (!TAG.equals(elem.getLocalName())) {
            this.writer.die("Root element must be %s:%s, but found %s", elem.getPrefix(), TAG, elem);
        }
        this.findResources(elem);
        this.messagesWriter.findMessagesConfig(elem);
        XMLElement uiRoot = elem.consumeSingleChildElement();
        return this.writer.parseElementToField(uiRoot);
    }

    private JClassType consumeCssResourceType(XMLElement elem) throws UnableToCompleteException {
        String typeName = elem.consumeRawAttribute("type", null);
        if (typeName == null) {
            return this.cssResourceType;
        }
        return this.findCssResourceType(elem, typeName);
    }

    private JClassType consumeTypeAttribute(XMLElement elem) throws UnableToCompleteException {
        String resourceTypeName = elem.consumeRequiredRawAttribute("type");
        JClassType resourceType = this.oracle.findType(resourceTypeName);
        if (resourceType == null) {
            this.writer.die("In %s, no such type %s", elem, resourceTypeName);
        }
        return resourceType;
    }

    private void createData(XMLElement elem) throws UnableToCompleteException {
        String name = elem.consumeRequiredRawAttribute(FIELD_ATTRIBUTE);
        String source = elem.consumeRequiredRawAttribute(SOURCE_ATTRIBUTE);
        ImplicitDataResource dataMethod = this.bundleClass.createDataResource(name, source);
        FieldWriter field = this.fieldManager.registerField(this.dataResourceType, dataMethod.getName());
        field.setInitializer(String.format("%s.%s()", this.bundleClass.getFieldName(), dataMethod.getName()));
    }

    private void createImage(XMLElement elem) throws UnableToCompleteException {
        String name = elem.consumeRequiredRawAttribute(FIELD_ATTRIBUTE);
        String source = elem.consumeRawAttribute(SOURCE_ATTRIBUTE, null);
        Boolean flipRtl = elem.consumeBooleanConstantAttribute(FLIP_RTL_ATTRIBUTE);
        ImageResource.RepeatStyle repeatStyle = null;
        if (elem.hasAttribute(REPEAT_STYLE_ATTRIBUTE)) {
            String value = elem.consumeRawAttribute(REPEAT_STYLE_ATTRIBUTE);
            try {
                repeatStyle = ImageResource.RepeatStyle.valueOf(value);
            }
            catch (IllegalArgumentException e) {
                this.writer.die("In %s, bad repeatStyle value %s", elem, value);
            }
        }
        ImplicitImageResource imageMethod = this.bundleClass.createImageResource(name, source, flipRtl, repeatStyle);
        FieldWriter field = this.fieldManager.registerField(this.imageResourceType, imageMethod.getName());
        field.setInitializer(String.format("%s.%s()", this.bundleClass.getFieldName(), imageMethod.getName()));
    }

    private void createResource(XMLElement elem) throws UnableToCompleteException {
        JMethod factoryMethod;
        String resourceName = elem.consumeRequiredRawAttribute(FIELD_ATTRIBUTE);
        JClassType resourceType = this.consumeTypeAttribute(elem);
        if (elem.getAttributeCount() > 0) {
            this.writer.die("In %s, should only find attributes \"field\" and \"type\"", elem);
        }
        FieldWriter fieldWriter = this.fieldManager.registerField(resourceType, resourceName);
        OwnerField ownerField = this.writer.getOwnerClass().getUiField(resourceName);
        if (ownerField != null) {
            if (!resourceType.equals((Object)ownerField.getType().getRawType())) {
                this.writer.die("In %s, type must match %s", elem, ownerField);
            }
            if (ownerField.isProvided()) {
                fieldWriter.setInitializer("owner." + ownerField.getName());
                return;
            }
        }
        if ((factoryMethod = this.writer.getOwnerClass().getUiFactoryMethod(resourceType)) != null) {
            fieldWriter.setInitializer(String.format("owner.%s()", factoryMethod.getName()));
        }
    }

    private void createStyle(XMLElement elem) throws UnableToCompleteException {
        String body = elem.consumeUnescapedInnerText();
        String[] source = elem.consumeRawArrayAttribute(SOURCE_ATTRIBUTE);
        if (0 == body.length() && 0 == source.length) {
            this.writer.die("%s must have either a src attribute or body text", elem);
        }
        String name = elem.consumeRawAttribute(FIELD_ATTRIBUTE, "style");
        JClassType publicType = this.consumeCssResourceType(elem);
        String[] importTypeNames = elem.consumeRawArrayAttribute(IMPORT_ATTRIBUTE);
        LinkedHashSet<JClassType> importTypes = new LinkedHashSet<JClassType>();
        for (String type : importTypeNames) {
            importTypes.add(this.findCssResourceType(elem, type));
        }
        ImplicitCssResource cssMethod = this.bundleClass.createCssResource(name, source, publicType, body, importTypes);
        FieldWriter field = this.fieldManager.registerFieldForGeneratedCssResource(cssMethod);
        field.setInitializer(String.format("%s.%s()", this.bundleClass.getFieldName(), cssMethod.getName()));
    }

    private JClassType findCssResourceType(XMLElement elem, String typeName) throws UnableToCompleteException {
        JClassType publicType = this.oracle.findType(typeName);
        if (publicType == null) {
            this.writer.die("In %s, no such type %s", elem, typeName);
        }
        if (!publicType.isAssignableTo(this.cssResourceType)) {
            this.writer.die("In %s, type %s does not extend %s", elem, publicType.getQualifiedSourceName(), this.cssResourceType.getQualifiedSourceName());
        }
        return publicType;
    }

    private void findResources(XMLElement binderElement) throws UnableToCompleteException {
        binderElement.consumeChildElements(new XMLElement.Interpreter<Boolean>(){

            @Override
            public Boolean interpretElement(XMLElement elem) throws UnableToCompleteException {
                if (UiBinderParser.this.writer.isBinderElement(elem)) {
                    try {
                        Resource.valueOf(elem.getLocalName()).create(UiBinderParser.this, elem);
                    }
                    catch (IllegalArgumentException e) {
                        UiBinderParser.this.writer.die("%s has unknown tag %s, or is not appropriate as a top level element", elem, elem.getLocalName());
                    }
                    return true;
                }
                return false;
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Resource {
        data{

            void create(UiBinderParser parser, XMLElement elem) throws UnableToCompleteException {
                parser.createData(elem);
            }
        }
        ,
        image{

            void create(UiBinderParser parser, XMLElement elem) throws UnableToCompleteException {
                parser.createImage(elem);
            }
        }
        ,
        style{

            void create(UiBinderParser parser, XMLElement elem) throws UnableToCompleteException {
                parser.createStyle(elem);
            }
        }
        ,
        with{

            void create(UiBinderParser parser, XMLElement elem) throws UnableToCompleteException {
                parser.createResource(elem);
            }
        };


        abstract void create(UiBinderParser var1, XMLElement var2) throws UnableToCompleteException;
    }
}

