/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.rebind;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.core.ext.typeinfo.TypeOracleException;
import com.google.gwt.dom.client.Style;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.uibinder.attributeparsers.AttributeParser;
import com.google.gwt.uibinder.attributeparsers.AttributeParsers;
import com.google.gwt.uibinder.attributeparsers.BundleAttributeParsers;
import com.google.gwt.uibinder.rebind.GetEscapedInnerTextVisitor;
import com.google.gwt.uibinder.rebind.GetInnerHtmlVisitor;
import com.google.gwt.uibinder.rebind.MortalLogger;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import com.google.gwt.uibinder.rebind.XMLAttribute;
import com.google.gwt.uibinder.rebind.XMLElementProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLElement {
    private static final Set<String> NO_END_TAG = new HashSet<String>();
    private static final String[] EMPTY = new String[0];
    private final Element elem;
    private final AttributeParsers attributeParsers;
    private final BundleAttributeParsers bundleParsers;
    private final TypeOracle oracle;
    private final MortalLogger logger;
    private final String debugString;
    private final XMLElementProvider provider;
    private JType booleanType;
    private JType imageResourceType;
    private JType doubleType;
    private JType stringType;

    private static void clearChildren(Element elem) {
        Node child;
        while ((child = elem.getFirstChild()) != null) {
            elem.removeChild(child);
        }
    }

    XMLElement(Element elem, AttributeParsers attributeParsers, BundleAttributeParsers bundleParsers, TypeOracle oracle, MortalLogger logger, XMLElementProvider provider) {
        NO_END_TAG.add("area");
        NO_END_TAG.add("base");
        NO_END_TAG.add("basefont");
        NO_END_TAG.add("br");
        NO_END_TAG.add("col");
        NO_END_TAG.add("frame");
        NO_END_TAG.add("hr");
        NO_END_TAG.add("img");
        NO_END_TAG.add("input");
        NO_END_TAG.add("isindex");
        NO_END_TAG.add("link");
        NO_END_TAG.add("meta");
        NO_END_TAG.add("param");
        NO_END_TAG.add("wbr");
        this.elem = elem;
        this.attributeParsers = attributeParsers;
        this.bundleParsers = bundleParsers;
        this.logger = logger;
        this.oracle = oracle;
        this.provider = provider;
        this.debugString = this.getOpeningTag();
    }

    public void assertNoAttributes() throws UnableToCompleteException {
        int numAtts = this.getAttributeCount();
        if (numAtts == 0) {
            return;
        }
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < numAtts; ++i) {
            if (i > 0) {
                b.append(", ");
            }
            b.append('\"').append(this.getAttribute(i).getName()).append('\"');
        }
        this.logger.die("Unexpected attributes in %s: %s", this, b);
    }

    public void assertNoBody() throws UnableToCompleteException {
        this.consumeChildElements(new Interpreter<Boolean>(){

            @Override
            public Boolean interpretElement(XMLElement elem) throws UnableToCompleteException {
                XMLElement.this.logger.die("In %s, found unexpected child \"%s\"", this, elem);
                return false;
            }
        });
        this.assertNoText();
    }

    public void assertNoText() throws UnableToCompleteException {
        NoBrainInterpeter<Object> nullInterpreter = new NoBrainInterpeter<Object>(null);
        String s = this.consumeInnerTextEscapedAsHtmlStringLiteral(nullInterpreter);
        if (!"".equals(s)) {
            this.logger.die("Unexpected text in %s: \"%s\"", this, s);
        }
    }

    public String consumeAttribute(String name, JType type) throws UnableToCompleteException {
        return this.consumeAttributeWithDefault(name, null, type);
    }

    public String consumeAttributeWithDefault(String name, String defaultValue, JType type) throws UnableToCompleteException {
        return this.consumeAttributeWithDefault(name, defaultValue, new JType[]{type});
    }

    public String consumeAttributeWithDefault(String name, String defaultValue, JType[] types) throws UnableToCompleteException {
        XMLAttribute attribute = this.getAttribute(name);
        if (attribute == null) {
            return defaultValue;
        }
        String value = attribute.consumeRawValue();
        return this.getParser(attribute, types).parse(value);
    }

    public String consumeBooleanAttribute(String name) throws UnableToCompleteException {
        return this.consumeAttribute(name, this.getBooleanType());
    }

    public String consumeBooleanAttribute(String name, boolean defaultValue) throws UnableToCompleteException {
        return this.consumeAttributeWithDefault(name, Boolean.toString(defaultValue), this.getBooleanType());
    }

    public Boolean consumeBooleanConstantAttribute(String name) throws UnableToCompleteException {
        String value = this.consumeRawAttribute(name);
        if (value == null) {
            return null;
        }
        if (value.equals("true") || value.equals("false")) {
            return Boolean.valueOf(value);
        }
        this.logger.die("In %s, %s must be \"true\" or \"false\"", this, name);
        return null;
    }

    public Iterable<XMLElement> consumeChildElements() throws UnableToCompleteException {
        Iterable<XMLElement> rtn = this.consumeChildElementsNoEmptyCheck();
        this.assertNoText();
        return rtn;
    }

    public Collection<XMLElement> consumeChildElements(Interpreter<Boolean> interpreter) throws UnableToCompleteException {
        ArrayList<XMLElement> elements = new ArrayList<XMLElement>();
        ArrayList<Node> doomed = new ArrayList<Node>();
        NodeList childNodes = this.elem.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            XMLElement childElement;
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() != 1 || !interpreter.interpretElement(childElement = this.provider.get((Element)childNode)).booleanValue()) continue;
            elements.add(childElement);
            doomed.add(childNode);
        }
        for (Node n : doomed) {
            this.elem.removeChild(n);
        }
        return elements;
    }

    public String consumeImageResourceAttribute(String name) throws UnableToCompleteException {
        return this.consumeAttribute(name, this.getImageResourceType());
    }

    public String consumeInnerHtml(Interpreter<String> interpreter) throws UnableToCompleteException {
        if (interpreter == null) {
            throw new NullPointerException("interpreter must not be null");
        }
        StringBuffer buf = new StringBuffer();
        GetInnerHtmlVisitor.getEscapedInnerHtml(this.elem, buf, interpreter, this.provider);
        XMLElement.clearChildren(this.elem);
        return buf.toString().trim();
    }

    public String consumeInnerHtml(PostProcessingInterpreter<String> interpreter) throws UnableToCompleteException {
        String html = this.consumeInnerHtml((Interpreter<String>)interpreter);
        return interpreter.postProcess(html);
    }

    public String consumeInnerText(PostProcessingInterpreter<String> interpreter) throws UnableToCompleteException {
        String text = this.consumeInnerTextEscapedAsHtmlStringLiteral(interpreter);
        return interpreter.postProcess(text);
    }

    public String consumeInnerTextEscapedAsHtmlStringLiteral(Interpreter<String> interpreter) throws UnableToCompleteException {
        if (interpreter == null) {
            throw new NullPointerException("interpreter must not be null");
        }
        StringBuffer buf = new StringBuffer();
        GetEscapedInnerTextVisitor.getEscapedInnerText(this.elem, buf, interpreter, this.provider);
        for (XMLElement child : this.consumeChildElementsNoEmptyCheck()) {
            if (!child.hasChildNodes() && child.getAttributeCount() <= 0) continue;
            this.logger.die("%s has illegal child %s", this, child);
        }
        XMLElement.clearChildren(this.elem);
        return buf.toString().trim();
    }

    public String consumeLengthAttribute(String name) throws UnableToCompleteException {
        return this.consumeAttributeWithDefault(name, null, new JType[]{this.getDoubleType(), this.getUnitType()});
    }

    public String consumeOpeningTag() {
        String rtn = this.getOpeningTag();
        for (int i = this.getAttributeCount() - 1; i >= 0; --i) {
            this.getAttribute(i).consumeRawValue();
        }
        return rtn;
    }

    public String[] consumeRawArrayAttribute(String name) {
        String raw = this.consumeRawAttribute(name, null);
        if (raw == null) {
            return EMPTY;
        }
        return raw.split("[,\\s]+");
    }

    public String consumeRawAttribute(String name) {
        if (!this.elem.hasAttribute(name)) {
            return null;
        }
        String value = this.elem.getAttribute(name);
        this.elem.removeAttribute(name);
        return value.trim();
    }

    public String consumeRawAttribute(String name, String defaultValue) {
        String value = this.consumeRawAttribute(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public String consumeRequiredAttribute(String name, JType ... types) throws UnableToCompleteException {
        XMLAttribute attribute = this.getAttribute(name);
        if (attribute == null) {
            this.failRequired(name);
        }
        AttributeParser parser = this.getParser(attribute, types);
        String value = this.consumeRequiredRawAttribute(name);
        return parser.parse(value);
    }

    public String consumeRequiredDoubleAttribute(String name) throws UnableToCompleteException {
        return this.consumeRequiredAttribute(name, this.getDoubleType());
    }

    public String consumeRequiredRawAttribute(String name) throws UnableToCompleteException {
        String value = this.consumeRawAttribute(name);
        if (value == null) {
            this.failRequired(name);
        }
        return value;
    }

    public XMLElement consumeSingleChildElement() throws UnableToCompleteException {
        XMLElement ret = null;
        for (XMLElement child : this.consumeChildElements()) {
            if (ret != null) {
                this.logger.die("%s may only contain a single child element, but found %s and %s.", this, ret, child);
            }
            ret = child;
        }
        if (ret == null) {
            this.logger.die("%s must have a single child element", this);
        }
        return ret;
    }

    public String[] consumeStringArrayAttribute(String name) throws UnableToCompleteException {
        AttributeParser parser = this.attributeParsers.get(this.getStringType());
        String[] strings = this.consumeRawArrayAttribute(name);
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = parser.parse(strings[i]);
        }
        return strings;
    }

    public String consumeStringAttribute(String name) throws UnableToCompleteException {
        return this.consumeAttribute(name, this.getStringType());
    }

    public String consumeStringAttribute(String name, String defaultValue) throws UnableToCompleteException {
        return this.consumeAttributeWithDefault(name, defaultValue, this.getStringType());
    }

    public String consumeUnescapedInnerText() throws UnableToCompleteException {
        NodeList children = this.elem.getChildNodes();
        if (children.getLength() < 1) {
            return "";
        }
        if (children.getLength() > 1 || 3 != children.item(0).getNodeType()) {
            this.logger.die("%s must contain only text", this);
        }
        Text t = (Text)children.item(0);
        return t.getTextContent();
    }

    public XMLAttribute getAttribute(int i) {
        return new XMLAttribute(this, (Attr)this.elem.getAttributes().item(i));
    }

    public XMLAttribute getAttribute(String name) {
        Attr attr = this.elem.getAttributeNode(name);
        if (attr == null) {
            return null;
        }
        return new XMLAttribute(this, attr);
    }

    public int getAttributeCount() {
        return this.elem.getAttributes().getLength();
    }

    public String getClosingTag() {
        if (NO_END_TAG.contains(this.elem.getTagName())) {
            return "";
        }
        return String.format("</%s>", this.elem.getTagName());
    }

    public String getLocalName() {
        return this.elem.getLocalName();
    }

    public String getNamespaceUri() {
        return this.elem.getNamespaceURI();
    }

    public String getNamespaceUriForAttribute(String fieldName) {
        Attr attr = this.elem.getAttributeNode(fieldName);
        return attr.getNamespaceURI();
    }

    public XMLElement getParent() {
        Node parent = this.elem.getParentNode();
        if (parent == null || 1 != parent.getNodeType()) {
            return null;
        }
        return this.provider.get((Element)parent);
    }

    public String getPrefix() {
        return this.elem.getPrefix();
    }

    public boolean hasAttribute(String name) {
        return this.elem.hasAttribute(name);
    }

    public boolean hasChildNodes() {
        return this.elem.hasChildNodes();
    }

    public String lookupPrefix(String prefix) {
        return this.elem.lookupPrefix(prefix);
    }

    public void setAttribute(String name, String value) {
        this.elem.setAttribute(name, value);
    }

    public String toString() {
        return this.debugString;
    }

    private Iterable<XMLElement> consumeChildElementsNoEmptyCheck() {
        try {
            Collection<XMLElement> rtn = this.consumeChildElements(new NoBrainInterpeter<Boolean>(true));
            return rtn;
        }
        catch (UnableToCompleteException e) {
            throw new RuntimeException("Impossible exception", e);
        }
    }

    private void failRequired(String name) throws UnableToCompleteException {
        this.logger.die("In %s, missing required attribute \"%s\"", this, name);
    }

    private JType getBooleanType() {
        if (this.booleanType == null) {
            try {
                this.booleanType = this.oracle.parse("boolean");
            }
            catch (TypeOracleException e) {
                throw new RuntimeException(e);
            }
        }
        return this.booleanType;
    }

    private JType getDoubleType() {
        if (this.doubleType == null) {
            try {
                this.doubleType = this.oracle.parse("double");
            }
            catch (TypeOracleException e) {
                throw new RuntimeException(e);
            }
        }
        return this.doubleType;
    }

    private JType getImageResourceType() {
        if (this.imageResourceType == null) {
            this.imageResourceType = this.oracle.findType(ImageResource.class.getCanonicalName());
        }
        return this.imageResourceType;
    }

    private String getOpeningTag() {
        StringBuilder b = new StringBuilder().append("<").append(this.elem.getTagName());
        NamedNodeMap attrs = this.elem.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            b.append(String.format(" %s='%s'", attr.getName(), UiBinderWriter.escapeAttributeText(attr.getValue())));
        }
        b.append(">");
        return b.toString();
    }

    private AttributeParser getParser(XMLAttribute xmlAttribute, JType ... types) throws UnableToCompleteException {
        AttributeParser rtn = this.bundleParsers.get(xmlAttribute);
        if (rtn == null) {
            rtn = this.attributeParsers.get(types);
        }
        return rtn;
    }

    private JType getStringType() {
        if (this.stringType == null) {
            this.stringType = this.oracle.findType(String.class.getCanonicalName());
        }
        return this.stringType;
    }

    private JClassType getUnitType() {
        return this.oracle.findType(Style.Unit.class.getCanonicalName()).isEnum();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Interpreter<T> {
        public T interpretElement(XMLElement var1) throws UnableToCompleteException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NoBrainInterpeter<T>
    implements Interpreter<T> {
        private final T rtn;

        public NoBrainInterpeter(T rtn) {
            this.rtn = rtn;
        }

        @Override
        public T interpretElement(XMLElement elem) {
            return this.rtn;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface PostProcessingInterpreter<T>
    extends Interpreter<T> {
        public String postProcess(String var1) throws UnableToCompleteException;
    }
}

