/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.rebind.model;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JConstructor;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.core.ext.typeinfo.JParameter;
import com.google.gwt.core.ext.typeinfo.JPrimitiveType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.uibinder.client.UiConstructor;
import com.google.gwt.uibinder.rebind.MortalLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OwnerFieldClass {
    private static final Map<JClassType, OwnerFieldClass> FIELD_CLASSES = new HashMap<JClassType, OwnerFieldClass>();
    private final JClassType rawType;
    private final Map<String, JMethod> setters = new HashMap<String, JMethod>();
    private Set<String> ambiguousSetters;
    private JConstructor uiConstructor;
    private final MortalLogger logger;

    public static OwnerFieldClass getFieldClass(JClassType forType, MortalLogger logger) throws UnableToCompleteException {
        OwnerFieldClass clazz = FIELD_CLASSES.get(forType);
        if (clazz == null) {
            clazz = new OwnerFieldClass(forType, logger);
            FIELD_CLASSES.put(forType, clazz);
        }
        return clazz;
    }

    OwnerFieldClass(JClassType forType, MortalLogger logger) throws UnableToCompleteException {
        this.rawType = forType;
        this.logger = logger;
        this.findUiConstructor(forType);
        this.findSetters(forType);
    }

    public JClassType getRawType() {
        return this.rawType;
    }

    public JMethod getSetter(String propertyName) throws UnableToCompleteException {
        if (this.ambiguousSetters != null && this.ambiguousSetters.contains(propertyName)) {
            this.logger.die("Ambiguous setter requested: " + this.rawType.getName() + "." + propertyName, new Object[0]);
        }
        return this.setters.get(propertyName);
    }

    public JConstructor getUiConstructor() {
        return this.uiConstructor;
    }

    private JMethod disambiguateSetters(Collection<JMethod> propertySetters) {
        if (propertySetters.size() == 1) {
            return propertySetters.iterator().next();
        }
        for (JMethod method : propertySetters) {
            JParameter[] parameters = method.getParameters();
            if (parameters.length != 1 || !parameters[0].getType().getQualifiedSourceName().equals("java.lang.String")) continue;
            return method;
        }
        JMethod firstMethod = null;
        for (JMethod method : propertySetters) {
            if (firstMethod == null) {
                firstMethod = method;
                continue;
            }
            if (this.sameParameterTypes(method, firstMethod)) continue;
            return null;
        }
        return firstMethod;
    }

    private Map<String, Collection<JMethod>> findAllSetters(JClassType fieldType) {
        JMethod[] methods;
        JClassType superClass = fieldType.getSuperclass();
        Map<String, Collection<JMethod>> allSetters = superClass != null ? this.findAllSetters(superClass) : new HashMap<String, Collection<JMethod>>();
        for (JMethod method : methods = fieldType.getMethods()) {
            if (!this.isSetterMethod(method)) continue;
            String propertyName = method.getName().substring(3);
            Collection<JMethod> propertyMethods = allSetters.get(propertyName = propertyName.substring(0, 1).toLowerCase() + propertyName.substring(1));
            if (propertyMethods == null) {
                propertyMethods = new ArrayList<JMethod>();
                allSetters.put(propertyName, propertyMethods);
            }
            propertyMethods.add(method);
        }
        return allSetters;
    }

    private void findSetters(JClassType fieldType) {
        Map<String, Collection<JMethod>> allSetters = this.findAllSetters(fieldType);
        for (String propertyName : allSetters.keySet()) {
            Collection<JMethod> propertySetters = allSetters.get(propertyName);
            JMethod setter = this.disambiguateSetters(propertySetters);
            if (setter == null) {
                if (this.ambiguousSetters == null) {
                    this.ambiguousSetters = new HashSet<String>();
                }
                this.ambiguousSetters.add(propertyName);
            }
            this.setters.put(propertyName, setter);
        }
    }

    private void findUiConstructor(JClassType fieldType) throws UnableToCompleteException {
        for (JConstructor ctor : fieldType.getConstructors()) {
            if (ctor.getAnnotation(UiConstructor.class) == null) continue;
            if (this.uiConstructor != null) {
                this.logger.die(fieldType.getName() + " has more than one constructor annotated with @UiConstructor", new Object[0]);
            }
            this.uiConstructor = ctor;
        }
    }

    private boolean isSetterMethod(JMethod method) {
        return method.isPublic() && !method.isStatic() && method.getName().startsWith("set") && method.getName().length() > 3 && method.getReturnType() == JPrimitiveType.VOID;
    }

    private boolean sameParameterTypes(JMethod m1, JMethod m2) {
        JParameter[] p2;
        JParameter[] p1 = m1.getParameters();
        if (p1.length != (p2 = m2.getParameters()).length) {
            return false;
        }
        for (int i = 0; i < p1.length; ++i) {
            JType type2;
            JType type1 = p1[i].getType();
            if (type1.equals((Object)(type2 = p2[i].getType()))) continue;
            return false;
        }
        return true;
    }
}

