/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.rebind;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.RunAsyncCallback;
import com.google.gwt.core.ext.Generator;
import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.core.ext.typeinfo.JParameter;
import com.google.gwt.core.ext.typeinfo.JParameterizedType;
import com.google.gwt.core.ext.typeinfo.JPrimitiveType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.user.client.AsyncProxy;
import com.google.gwt.user.client.impl.AsyncProxyBase;
import com.google.gwt.user.rebind.ClassSourceFileComposerFactory;
import com.google.gwt.user.rebind.SourceWriter;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Iterator;

public class AsyncProxyGenerator
extends Generator {
    public String generate(TreeLogger logger, GeneratorContext generatorContext, String typeName) throws UnableToCompleteException {
        TypeOracle typeOracle = generatorContext.getTypeOracle();
        JClassType asyncProxyType = typeOracle.findType(AsyncProxy.class.getName());
        JClassType asyncProxyBaseType = typeOracle.findType(AsyncProxyBase.class.getName());
        JClassType sourceType = typeOracle.findType(typeName);
        if (sourceType == null) {
            logger.log(TreeLogger.ERROR, "Could not find requested typeName");
            throw new UnableToCompleteException();
        }
        if (sourceType.isInterface() == null) {
            logger.log(TreeLogger.ERROR, sourceType.getQualifiedSourceName() + " is not an interface.", null);
            throw new UnableToCompleteException();
        }
        JClassType concreteType = this.getConcreteType(logger, typeOracle, sourceType);
        JClassType paramType = this.getParamType(logger, asyncProxyType, sourceType);
        this.validate(logger, sourceType, concreteType, paramType);
        String generatedSimpleSourceName = sourceType.getQualifiedSourceName().replace('.', '_').replace('$', '_') + "Impl";
        ClassSourceFileComposerFactory f = new ClassSourceFileComposerFactory(sourceType.getPackage().getName(), generatedSimpleSourceName);
        String createdClassName = f.getCreatedClassName();
        f.addImport(GWT.class.getName());
        f.addImport(RunAsyncCallback.class.getName());
        f.setSuperclass(asyncProxyBaseType.getQualifiedSourceName() + "<" + paramType.getQualifiedSourceName() + ">");
        f.addImplementedInterface(sourceType.getQualifiedSourceName());
        PrintWriter out = generatorContext.tryCreate(logger, sourceType.getPackage().getName(), generatedSimpleSourceName);
        if (out != null) {
            SourceWriter sw = f.createSourceWriter(generatorContext, out);
            sw.println("protected void doAsync0() {");
            sw.indent();
            sw.println("GWT.runAsync(new RunAsyncCallback() {");
            sw.indentln("public void onFailure(Throwable caught) {doFailure0(caught);}");
            sw.indentln("public void onSuccess() {setInstance0(doCreate0());}");
            sw.println("});");
            sw.outdent();
            sw.println("}");
            String proxyCallback = "ProxyCallback<" + paramType.getQualifiedSourceName() + ">";
            sw.println("private " + proxyCallback + " callback;");
            sw.println("public void setProxyCallback(" + proxyCallback + " callback) {this.callback = callback;}");
            sw.println("protected " + proxyCallback + " getCallback0() {return callback;}");
            sw.println("private " + paramType.getQualifiedSourceName() + " doCreate0() {");
            sw.indent();
            sw.println("return GWT.create(" + concreteType.getQualifiedSourceName() + ".class);");
            sw.outdent();
            sw.println("}");
            boolean allowNonVoid = sourceType.getAnnotation(AsyncProxy.AllowNonVoid.class) != null;
            for (JMethod method : paramType.getOverridableMethods()) {
                AsyncProxy.DefaultValue defaults = this.getDefaultValue(sourceType, method);
                if (method.getReturnType() != JPrimitiveType.VOID && !allowNonVoid) {
                    logger.log(TreeLogger.ERROR, "The method " + method.getName() + " returns a type other than void, but " + sourceType.getQualifiedSourceName() + " does not define the " + AsyncProxy.AllowNonVoid.class.getSimpleName() + " annotation.");
                    throw new UnableToCompleteException();
                }
                sw.print("public " + method.getReturnType().getQualifiedSourceName() + " " + method.getName() + "(");
                Iterator<JParameter> i = Arrays.asList(method.getParameters()).iterator();
                while (i.hasNext()) {
                    JParameter param = i.next();
                    sw.print("final " + param.getType().getQualifiedSourceName() + " " + param.getName());
                    if (!i.hasNext()) continue;
                    sw.print(", ");
                }
                sw.println(") {");
                sw.indent();
                sw.println("if (getProxiedInstance() != null) {");
                sw.indent();
                if (method.getReturnType() != JPrimitiveType.VOID) {
                    sw.print("return ");
                }
                this.writeInvocation(sw, "getProxiedInstance()", method);
                sw.outdent();
                sw.println("} else {");
                sw.indent();
                sw.println("enqueue0(new ParamCommand<" + paramType.getQualifiedSourceName() + ">() {");
                sw.indent();
                sw.println("public void execute(" + paramType.getQualifiedSourceName() + " t) {");
                sw.indent();
                this.writeInvocation(sw, "t", method);
                sw.outdent();
                sw.println("}");
                sw.outdent();
                sw.println("});");
                if (method.getReturnType() != JPrimitiveType.VOID) {
                    sw.println("return " + this.getDefaultExpression(defaults, method.getReturnType()) + ";");
                }
                sw.outdent();
                sw.println("}");
                sw.outdent();
                sw.println("}");
            }
            sw.commit(logger);
        }
        return createdClassName;
    }

    private JClassType getConcreteType(TreeLogger logger, TypeOracle typeOracle, JClassType sourceType) throws UnableToCompleteException {
        AsyncProxy.ConcreteType concreteTypeAnnotation = (AsyncProxy.ConcreteType)sourceType.getAnnotation(AsyncProxy.ConcreteType.class);
        if (concreteTypeAnnotation == null) {
            logger.log(TreeLogger.ERROR, "AsnycProxy subtypes must specify a " + AsyncProxy.ConcreteType.class.getSimpleName() + " annotation.");
            throw new UnableToCompleteException();
        }
        String concreteTypeName = concreteTypeAnnotation.value().getName().replace('$', '.');
        JClassType concreteType = typeOracle.findType(concreteTypeName);
        if (concreteType == null) {
            logger.log(TreeLogger.ERROR, "Unable to find concrete type; is it in the GWT source path?");
            throw new UnableToCompleteException();
        }
        return concreteType;
    }

    private String getDefaultExpression(AsyncProxy.DefaultValue defaultValue, JType type) {
        if (!(type instanceof JPrimitiveType)) {
            return "null";
        }
        if (type == JPrimitiveType.BOOLEAN) {
            return String.valueOf(defaultValue.booleanValue());
        }
        if (type == JPrimitiveType.BYTE) {
            return String.valueOf(defaultValue.byteValue());
        }
        if (type == JPrimitiveType.CHAR) {
            return String.valueOf((int)defaultValue.charValue());
        }
        if (type == JPrimitiveType.DOUBLE) {
            return String.valueOf(defaultValue.doubleValue());
        }
        if (type == JPrimitiveType.FLOAT) {
            return String.valueOf(defaultValue.floatValue()) + "F";
        }
        if (type == JPrimitiveType.INT) {
            return String.valueOf(defaultValue.intValue());
        }
        if (type == JPrimitiveType.LONG) {
            return String.valueOf(defaultValue.longValue());
        }
        if (type == JPrimitiveType.SHORT) {
            return String.valueOf(defaultValue.shortValue());
        }
        if (type == JPrimitiveType.VOID) assert (false) : "Should not pass VOID into this method";
        assert (false) : "Should never reach here";
        return null;
    }

    private AsyncProxy.DefaultValue getDefaultValue(JClassType sourceType, JMethod method) {
        AsyncProxy.DefaultValue toReturn = (AsyncProxy.DefaultValue)method.getAnnotation(AsyncProxy.DefaultValue.class);
        if (toReturn == null) {
            toReturn = (AsyncProxy.DefaultValue)sourceType.getAnnotation(AsyncProxy.DefaultValue.class);
        }
        if (toReturn == null) {
            JClassType proxyType = sourceType.getOracle().findType(AsyncProxy.class.getName());
            toReturn = (AsyncProxy.DefaultValue)proxyType.getAnnotation(AsyncProxy.DefaultValue.class);
        }
        assert (toReturn != null) : "Could not find any DefaultValue instance";
        return toReturn;
    }

    private JClassType getParamType(TreeLogger logger, JClassType asyncProxyType, JClassType sourceType) throws UnableToCompleteException {
        JClassType paramType = null;
        for (JClassType intr : sourceType.getImplementedInterfaces()) {
            JParameterizedType isParameterized = intr.isParameterized();
            if (isParameterized == null || !isParameterized.getBaseType().equals((Object)asyncProxyType)) continue;
            paramType = isParameterized.getTypeArgs()[0];
            break;
        }
        if (paramType == null) {
            logger.log(TreeLogger.ERROR, "Unable to determine parameterization type.");
            throw new UnableToCompleteException();
        }
        return paramType;
    }

    private void validate(TreeLogger logger, JClassType sourceType, JClassType concreteType, JClassType paramType) throws UnableToCompleteException {
        if (sourceType.getMethods().length > 0) {
            logger.log(TreeLogger.ERROR, "AsyncProxy subtypes may not define any additional methods");
            throw new UnableToCompleteException();
        }
        if (!sourceType.isAssignableTo(paramType)) {
            logger.log(TreeLogger.ERROR, "Expecting " + sourceType.getQualifiedSourceName() + " to implement " + paramType.getQualifiedSourceName());
            throw new UnableToCompleteException();
        }
        if (!concreteType.isAssignableTo(paramType)) {
            logger.log(TreeLogger.ERROR, "Expecting concrete type" + concreteType.getQualifiedSourceName() + " to implement " + paramType.getQualifiedSourceName());
            throw new UnableToCompleteException();
        }
        if (!concreteType.isStatic()) {
            logger.log(TreeLogger.ERROR, "Expecting concrete type" + concreteType.getQualifiedSourceName() + " to be static.");
            throw new UnableToCompleteException();
        }
    }

    private void writeInvocation(SourceWriter sw, String qualifier, JMethod method) {
        sw.print(qualifier + "." + method.getName() + "(");
        Iterator<JParameter> i = Arrays.asList(method.getParameters()).iterator();
        while (i.hasNext()) {
            JParameter param = i.next();
            sw.print(param.getName());
            if (!i.hasNext()) continue;
            sw.print(", ");
        }
        sw.println(");");
    }
}

