/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.rebind.rpc;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsArrayString;
import com.google.gwt.core.ext.BadPropertyValueException;
import com.google.gwt.core.ext.ConfigurationProperty;
import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.core.ext.typeinfo.JParameterizedType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.dev.javac.TypeOracleMediator;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.client.rpc.SerializationStreamReader;
import com.google.gwt.user.client.rpc.SerializationStreamWriter;
import com.google.gwt.user.client.rpc.impl.Serializer;
import com.google.gwt.user.client.rpc.impl.SerializerBase;
import com.google.gwt.user.rebind.ClassSourceFileComposerFactory;
import com.google.gwt.user.rebind.SourceWriter;
import com.google.gwt.user.rebind.rpc.CustomFieldSerializerValidator;
import com.google.gwt.user.rebind.rpc.FieldSerializerCreator;
import com.google.gwt.user.rebind.rpc.SerializableTypeOracle;
import com.google.gwt.user.rebind.rpc.SerializableTypeOracleBuilder;
import com.google.gwt.user.rebind.rpc.SerializationUtils;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeSerializerCreator {
    public static final String GWT_ELIDE_TYPE_NAMES_FROM_RPC = "gwt.elideTypeNamesFromRPC";
    private static final String DEFAULT_CREATEMETHODMAP_SHARD_SIZE = "0";
    private static final String GWT_CREATEMETHODMAP_SHARD_SIZE = "gwt.typecreator.shard.size";
    private static int shardSize = -1;
    private final GeneratorContext context;
    private final SerializableTypeOracle deserializationOracle;
    private final boolean elideTypeNames;
    private final SerializableTypeOracle serializationOracle;
    private final JType[] serializableTypes;
    private final SourceWriter srcWriter;
    private final TypeOracle typeOracle;
    private final String typeSerializerClassName;
    private final Map<JType, String> typeStrings = new IdentityHashMap<JType, String>();

    private static void computeShardSize(TreeLogger logger) throws UnableToCompleteException {
        String shardSizeProperty = System.getProperty(GWT_CREATEMETHODMAP_SHARD_SIZE, DEFAULT_CREATEMETHODMAP_SHARD_SIZE);
        try {
            shardSize = Integer.valueOf(shardSizeProperty);
            if (shardSize < 0) {
                logger.log(TreeLogger.ERROR, "gwt.typecreator.shard.size must be non-negative: " + shardSizeProperty);
                throw new UnableToCompleteException();
            }
        }
        catch (NumberFormatException e) {
            logger.log(TreeLogger.ERROR, "Property gwt.typecreator.shard.size not a number: " + shardSizeProperty, (Throwable)e);
            throw new UnableToCompleteException();
        }
    }

    public TypeSerializerCreator(TreeLogger logger, SerializableTypeOracle serializationOracle, SerializableTypeOracle deserializationOracle, GeneratorContext context, String typeSerializerClassName) throws UnableToCompleteException {
        this.context = context;
        this.typeSerializerClassName = typeSerializerClassName;
        this.serializationOracle = serializationOracle;
        this.deserializationOracle = deserializationOracle;
        this.typeOracle = context.getTypeOracle();
        HashSet<JType> typesSet = new HashSet<JType>();
        typesSet.addAll(Arrays.asList(serializationOracle.getSerializableTypes()));
        typesSet.addAll(Arrays.asList(deserializationOracle.getSerializableTypes()));
        this.serializableTypes = typesSet.toArray(new JType[0]);
        Arrays.sort(this.serializableTypes, SerializableTypeOracleBuilder.JTYPE_COMPARATOR);
        this.srcWriter = this.getSourceWriter(logger, context);
        if (shardSize < 0) {
            TypeSerializerCreator.computeShardSize(logger);
        }
        logger.log(TreeLogger.TRACE, "Using a shard size of " + shardSize + " for TypeSerializerCreator createMethodMap");
        try {
            ConfigurationProperty prop = context.getPropertyOracle().getConfigurationProperty(GWT_ELIDE_TYPE_NAMES_FROM_RPC);
            this.elideTypeNames = Boolean.parseBoolean((String)prop.getValues().get(0));
        }
        catch (BadPropertyValueException e) {
            logger.log(TreeLogger.ERROR, "The configuration property gwt.elideTypeNamesFromRPC was not defined. Is RemoteService.gwt.xml inherited?");
            throw new UnableToCompleteException();
        }
    }

    public Map<JType, String> getTypeStrings() {
        return Collections.unmodifiableMap(this.typeStrings);
    }

    public String realize(TreeLogger logger) throws UnableToCompleteException {
        logger = logger.branch(TreeLogger.DEBUG, "Generating TypeSerializer for service interface '" + this.getTypeSerializerClassName() + "'", null);
        String typeSerializerName = this.getTypeSerializerClassName();
        if (this.srcWriter == null) {
            return typeSerializerName;
        }
        this.createFieldSerializers(logger, this.context);
        this.writeStaticFields();
        this.writeStaticInitializer();
        this.writeCreateMethods();
        this.writeRegisterSignatures();
        this.writeRegisterMethods();
        this.writeRaiseSerializationException();
        this.srcWriter.commit(logger);
        return typeSerializerName;
    }

    private void createFieldSerializer(TreeLogger logger, GeneratorContext ctx, JType type) {
        assert (type != null);
        assert (this.serializationOracle.isSerializable(type) || this.deserializationOracle.isSerializable(type));
        JParameterizedType parameterizedType = type.isParameterized();
        if (parameterizedType != null) {
            this.createFieldSerializer(logger, ctx, (JType)parameterizedType.getRawType());
            return;
        }
        JClassType customFieldSerializer = SerializableTypeOracleBuilder.findCustomFieldSerializer(this.typeOracle, type);
        if (customFieldSerializer != null) {
            return;
        }
        assert (type.isClass() != null || type.isArray() != null);
        FieldSerializerCreator creator = new FieldSerializerCreator(this.typeOracle, this.serializationOracle, this.deserializationOracle, (JClassType)type);
        creator.realize(logger, ctx);
    }

    private void createFieldSerializers(TreeLogger logger, GeneratorContext ctx) {
        for (JType type : this.getSerializableTypes()) {
            assert (type != null);
            this.createFieldSerializer(logger, ctx, type);
        }
    }

    private String getCreateMethodName(JType type) {
        assert (type.isArray() == null);
        return "create_" + SerializationUtils.getFieldSerializerName(this.typeOracle, type).replace('.', '_');
    }

    private String[] getPackageAndClassName(String fullClassName) {
        String className = fullClassName;
        String packageName = "";
        int index = -1;
        index = className.lastIndexOf(46);
        if (index >= 0) {
            packageName = className.substring(0, index);
            className = className.substring(index + 1, className.length());
        }
        return new String[]{packageName, className};
    }

    private JType[] getSerializableTypes() {
        return this.serializableTypes;
    }

    private SourceWriter getSourceWriter(TreeLogger logger, GeneratorContext ctx) {
        String className;
        String[] name = this.getPackageAndClassName(this.getTypeSerializerClassName());
        String packageName = name[0];
        PrintWriter printWriter = ctx.tryCreate(logger, packageName, className = name[1]);
        if (printWriter == null) {
            return null;
        }
        ClassSourceFileComposerFactory composerFactory = new ClassSourceFileComposerFactory(packageName, className);
        composerFactory.addImport(JavaScriptObject.class.getName());
        composerFactory.addImport(JsArrayString.class.getName());
        composerFactory.addImport(Serializer.class.getName());
        composerFactory.addImport(SerializationException.class.getName());
        composerFactory.addImport(SerializationStreamReader.class.getName());
        composerFactory.addImport(SerializationStreamWriter.class.getName());
        composerFactory.setSuperclass(SerializerBase.class.getName());
        return composerFactory.createSourceWriter(ctx, printWriter);
    }

    private String getTypeSerializerClassName() {
        return this.typeSerializerClassName;
    }

    private String getTypeString(JType type) {
        String typeString = TypeOracleMediator.computeBinaryClassName((JType)type) + "/" + SerializationUtils.getSerializationSignature(this.typeOracle, type);
        return typeString;
    }

    private boolean needsCreateMethod(JType type) {
        if (!this.deserializationOracle.maybeInstantiated(type)) {
            return false;
        }
        if (type.isArray() != null) {
            return false;
        }
        JClassType customSerializer = SerializableTypeOracleBuilder.findCustomFieldSerializer(this.typeOracle, type);
        if (customSerializer == null) {
            return false;
        }
        JMethod customInstantiate = customSerializer.findMethod("instantiate", new JType[]{this.typeOracle.findType(SerializationStreamReader.class.getName())});
        return customInstantiate == null;
    }

    private void writeCreateMethods() {
        JType[] types = this.getSerializableTypes();
        for (int typeIndex = 0; typeIndex < types.length; ++typeIndex) {
            JType type = types[typeIndex];
            assert (this.serializationOracle.isSerializable(type) || this.deserializationOracle.isSerializable(type));
            if (!this.needsCreateMethod(type)) continue;
            this.srcWriter.print("private static native ");
            this.srcWriter.print(type.getQualifiedSourceName());
            this.srcWriter.print(" ");
            this.srcWriter.print(this.getCreateMethodName(type));
            this.srcWriter.println("(SerializationStreamReader streamReader) throws SerializationException /*-{");
            this.srcWriter.indent();
            this.srcWriter.print("return @");
            this.srcWriter.print(type.getQualifiedSourceName());
            this.srcWriter.println("::new()();");
            this.srcWriter.outdent();
            this.srcWriter.println("}-*/;");
            this.srcWriter.println();
        }
    }

    private void writeRaiseSerializationException() {
        this.srcWriter.println("private static void raiseSerializationException(String msg) throws SerializationException {");
        this.srcWriter.indentln("throw new SerializationException(msg);");
        this.srcWriter.println("}");
        this.srcWriter.println();
    }

    private void writeRegisterMethods() {
        this.srcWriter.println("private static native void registerMethods() /*-{");
        this.srcWriter.indent();
        ArrayList<JType> filteredTypes = new ArrayList<JType>();
        for (JType type : this.getSerializableTypes()) {
            if (!this.serializationOracle.maybeInstantiated(type) && !this.deserializationOracle.maybeInstantiated(type)) continue;
            filteredTypes.add(type);
        }
        boolean shard = shardSize > 0 && filteredTypes.size() > shardSize;
        int shardCount = 0;
        if (shard) {
            this.srcWriter.println("(function() {");
        }
        for (JType type : filteredTypes) {
            if (shard && ++shardCount % shardSize == 0) {
                this.srcWriter.println("})();");
                this.srcWriter.println("(function() {");
            }
            this.srcWriter.println("@com.google.gwt.user.client.rpc.impl.SerializerBase::registerMethods(Lcom/google/gwt/user/client/rpc/impl/SerializerBase$MethodMap;Ljava/lang/String;Lcom/google/gwt/core/client/JsArray;)(");
            this.srcWriter.indentln("@" + this.typeSerializerClassName + "::methodMap,");
            String typeString = this.typeStrings.get(type);
            assert (typeString != null) : "Missing type signature for " + type.getQualifiedSourceName();
            this.srcWriter.indentln("\"" + typeString + "\" , [");
            this.srcWriter.indent();
            this.writeTypeMethods(type);
            this.srcWriter.outdent();
            this.srcWriter.indentln("]);");
            this.srcWriter.println();
        }
        if (shard) {
            this.srcWriter.println("})();");
        }
        this.srcWriter.outdent();
        this.srcWriter.println("}-*/;");
        this.srcWriter.println();
    }

    private void writeRegisterSignatures() {
        this.srcWriter.println("private static native void registerSignatures() /*-{");
        this.srcWriter.indent();
        int index = 0;
        boolean shard = shardSize > 0 && this.getSerializableTypes().length > shardSize;
        int shardCount = 0;
        if (shard) {
            this.srcWriter.println("(function() {");
        }
        for (JType type : this.getSerializableTypes()) {
            String typeString = this.elideTypeNames ? Integer.toString(++index, 36) : this.getTypeString(type);
            this.typeStrings.put(type, typeString);
            if (!this.serializationOracle.maybeInstantiated(type) && !this.deserializationOracle.maybeInstantiated(type)) continue;
            String jsniTypeRef = TypeOracleMediator.computeBinaryClassName((JType)type.getLeafType());
            while (type.isArray() != null) {
                jsniTypeRef = jsniTypeRef + "[]";
                type = type.isArray().getComponentType();
            }
            if (shard && ++shardCount % shardSize == 0) {
                this.srcWriter.println("})();");
                this.srcWriter.println("(function() {");
            }
            this.srcWriter.println("@com.google.gwt.user.client.rpc.impl.SerializerBase::registerSignature(Lcom/google/gwt/core/client/JsArrayString;Ljava/lang/Class;Ljava/lang/String;)(");
            this.srcWriter.indent();
            this.srcWriter.println("@" + this.typeSerializerClassName + "::signatureMap,");
            this.srcWriter.println("@" + jsniTypeRef + "::class,");
            this.srcWriter.println("\"" + typeString + "\");");
            this.srcWriter.outdent();
            this.srcWriter.println();
        }
        if (shard) {
            this.srcWriter.println("})();");
        }
        this.srcWriter.outdent();
        this.srcWriter.println("}-*/;");
        this.srcWriter.println();
    }

    private void writeStaticFields() {
        this.srcWriter.println("private static final MethodMap methodMap = JavaScriptObject.createObject().cast();");
        this.srcWriter.println("private static final JsArrayString signatureMap = JavaScriptObject.createArray().cast();");
        this.srcWriter.println("protected MethodMap getMethodMap() { return methodMap; }");
        this.srcWriter.println("protected JsArrayString getSignatureMap() { return signatureMap; }");
        this.srcWriter.println();
    }

    private void writeStaticInitializer() {
        this.srcWriter.println("static {");
        this.srcWriter.indentln("registerMethods();");
        this.srcWriter.indentln("registerSignatures();");
        this.srcWriter.println("}");
    }

    private void writeTypeMethods(JType type) {
        JType paramType;
        this.srcWriter.indent();
        String serializerName = SerializationUtils.getFieldSerializerName(this.typeOracle, type);
        if (this.deserializationOracle.maybeInstantiated(type)) {
            this.srcWriter.print("@");
            if (this.needsCreateMethod(type)) {
                this.srcWriter.print(this.getTypeSerializerClassName());
                this.srcWriter.print("::");
                this.srcWriter.print(this.getCreateMethodName(type));
            } else {
                this.srcWriter.print(serializerName);
                this.srcWriter.print("::instantiate");
            }
            this.srcWriter.print("(L" + SerializationStreamReader.class.getName().replace('.', '/') + ";)");
        }
        this.srcWriter.println(",");
        JClassType customSerializer = SerializableTypeOracleBuilder.findCustomFieldSerializer(this.typeOracle, type);
        if (this.deserializationOracle.isSerializable(type)) {
            paramType = type;
            if (customSerializer != null) {
                JMethod deserializationMethod = CustomFieldSerializerValidator.getDeserializationMethod(customSerializer, (JClassType)type);
                paramType = deserializationMethod.getParameters()[1].getType();
            }
            this.srcWriter.print("@" + serializerName);
            this.srcWriter.print("::deserialize(L" + SerializationStreamReader.class.getName().replace('.', '/') + ";" + paramType.getJNISignature() + ")");
        }
        this.srcWriter.println(",");
        if (this.serializationOracle.isSerializable(type)) {
            paramType = type;
            if (customSerializer != null) {
                JMethod serializationMethod = CustomFieldSerializerValidator.getSerializationMethod(customSerializer, (JClassType)type);
                paramType = serializationMethod.getParameters()[1].getType();
            }
            this.srcWriter.print("@" + serializerName);
            this.srcWriter.print("::serialize(L" + SerializationStreamWriter.class.getName().replace('.', '/') + ";" + paramType.getJNISignature() + ")");
            this.srcWriter.println();
        }
        this.srcWriter.outdent();
    }
}

