/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.discovery;

import java.io.Serializable;
import java.net.URI;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.discovery.IServiceProperties;
import org.eclipse.ecf.discovery.ServiceProperties;
import org.eclipse.ecf.discovery.identity.IServiceID;
import org.eclipse.ecf.discovery.identity.IServiceTypeID;
import org.eclipse.ecf.discovery.identity.ServiceID;
import org.eclipse.ecf.internal.discovery.DiscoveryPlugin;

public class ServiceInfo
implements IServiceInfo,
Serializable {
    private static final long serialVersionUID = -5651115550295457142L;
    public static final long DEFAULT_TTL = 3600L;
    public static final int DEFAULT_PRIORITY = 0;
    public static final int DEFAULT_WEIGHT = 0;
    public static final String UNKNOWN_PROTOCOL = "unknown";
    protected String serviceName;
    protected IServiceID serviceID;
    protected int priority;
    protected int weight;
    protected IServiceProperties properties;
    protected long timeToLive;

    protected ServiceInfo() {
    }

    public ServiceInfo(URI anURI, String aServiceName, IServiceTypeID aServiceTypeID) {
        this(anURI, aServiceName, aServiceTypeID, 0, 0, null);
    }

    public ServiceInfo(URI anURI, String aServiceName, IServiceTypeID aServiceTypeID, IServiceProperties props) {
        this(anURI, aServiceName, aServiceTypeID, 0, 0, props);
    }

    public ServiceInfo(URI anURI, String aServiceName, IServiceTypeID aServiceTypeID, int priority, int weight, IServiceProperties props) {
        this(anURI, aServiceName, aServiceTypeID, priority, weight, props, 3600L);
    }

    public ServiceInfo(URI anURI, String aServiceName, IServiceTypeID aServiceTypeID, int priority, int weight, IServiceProperties props, long ttl) {
        String query;
        String path;
        String userInfo;
        Assert.isNotNull((Object)anURI);
        Assert.isNotNull((Object)aServiceName);
        Assert.isNotNull((Object)aServiceTypeID);
        String scheme = anURI.getScheme();
        if (scheme == null) {
            scheme = UNKNOWN_PROTOCOL;
        }
        userInfo = (userInfo = anURI.getUserInfo()) == null ? "" : String.valueOf(userInfo) + "@";
        String host = anURI.getHost();
        Assert.isNotNull((Object)host);
        int port = anURI.getPort();
        if (port == -1) {
            port = 0;
        }
        if ((path = anURI.getPath()) == null) {
            path = "/";
        }
        query = (query = anURI.getQuery()) == null ? "" : "?" + query;
        String fragment = anURI.getFragment();
        fragment = fragment == null ? "" : "#" + fragment;
        URI uri = URI.create(String.valueOf(scheme) + "://" + userInfo + host + ":" + port + path + query + fragment);
        Namespace ns = aServiceTypeID.getNamespace();
        this.serviceID = (IServiceID)ns.createInstance(new Object[]{aServiceTypeID, uri});
        ((ServiceID)this.serviceID).setServiceInfo(this);
        this.serviceName = aServiceName;
        this.weight = weight;
        this.priority = priority;
        this.properties = props == null ? new ServiceProperties() : props;
        this.timeToLive = ttl;
    }

    public URI getLocation() {
        return this.serviceID.getLocation();
    }

    public IServiceID getServiceID() {
        return this.serviceID;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getWeight() {
        return this.weight;
    }

    public IServiceProperties getServiceProperties() {
        return this.properties;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("ServiceInfo[");
        buf.append("uri=").append(this.getLocation()).append(";id=").append(this.serviceID).append(";priority=").append(this.priority).append(";weight=").append(this.weight).append(";props=").append(this.properties).append("]");
        return buf.toString();
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isInstance(this)) {
            return this;
        }
        IAdapterManager adapterManager = DiscoveryPlugin.getDefault().getAdapterManager();
        if (adapterManager == null) {
            return null;
        }
        return adapterManager.loadAdapter((Object)this, adapter.getName());
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public long getTTL() {
        return this.timeToLive;
    }
}

