/****************************************************************************
 * Copyright (c) 2004 Composent, Inc. and others.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * Contributors:
 *    Composent, Inc. - initial API and implementation
 *
 * SPDX-License-Identifier: EPL-2.0
 *****************************************************************************/
package org.eclipse.ecf.provider.comm;

import java.io.IOException;
import org.eclipse.ecf.core.identity.ID;

/**
 * Synchronous connection
 * 
 */
public interface ISynchConnection extends IConnection {
	/**
	 * Send data synchronously, blocking until a result is received
	 * 
	 * @param receiver
	 *            the receiver to receive the synchronous request
	 * @param data
	 *            the data to send
	 * @return the data received. The return type will be specific to the
	 *         provider implementation.
	 * @throws IOException
	 *             thrown if sending cannot occur (e.g. not connected)
	 */
	public Object sendSynch(ID receiver, byte[] data) throws IOException;
}