/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import org.eclipse.ecf.internal.ssl.SSLContextHelper;

public class ECFSSLServerSocketFactory
extends SSLServerSocketFactory {
    public static final String DEFAULT_SSL_PROTOCOL = "https.protocols";
    private String defaultProtocolNames = System.getProperty("https.protocols");
    private SSLContext sslContext = null;

    private SSLServerSocketFactory getSSLServerSocketFactory() throws IOException {
        if (this.sslContext == null) {
            try {
                this.sslContext = this.getSSLContext(this.defaultProtocolNames);
            }
            catch (Exception e) {
                IOException ioe = new IOException();
                ioe.initCause(e);
                throw ioe;
            }
        }
        return this.sslContext == null ? (SSLServerSocketFactory)SSLServerSocketFactory.getDefault() : this.sslContext.getServerSocketFactory();
    }

    public SSLContext getSSLContext(String protocols) {
        return SSLContextHelper.getSSLContext(protocols);
    }

    public String[] getDefaultCipherSuites() {
        try {
            return this.getSSLServerSocketFactory().getDefaultCipherSuites();
        }
        catch (IOException e) {
            return new String[0];
        }
    }

    public String[] getSupportedCipherSuites() {
        try {
            return this.getSSLServerSocketFactory().getSupportedCipherSuites();
        }
        catch (IOException e) {
            return new String[0];
        }
    }

    public ServerSocket createServerSocket(int arg0) throws IOException {
        return this.getSSLServerSocketFactory().createServerSocket(arg0);
    }

    public ServerSocket createServerSocket(int arg0, int arg1) throws IOException {
        return this.getSSLServerSocketFactory().createServerSocket(arg0, arg1);
    }

    public ServerSocket createServerSocket(int arg0, int arg1, InetAddress arg2) throws IOException {
        return this.getSSLServerSocketFactory().createServerSocket(arg0, arg1, arg2);
    }
}

