/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.server.generic;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerManager;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContainer;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContainerConfig;
import org.eclipse.ecf.internal.server.generic.Activator;
import org.eclipse.ecf.provider.generic.SOContainerConfig;
import org.eclipse.ecf.provider.generic.SSLServerSOContainer;
import org.eclipse.ecf.provider.generic.SSLServerSOContainerGroup;
import org.eclipse.ecf.server.generic.IGenericServerContainerGroup;

public class SSLGenericServerContainerGroup
implements IGenericServerContainerGroup {
    private SSLGenericServerSOContainerGroup serverGroup;
    private Map defaultContainerProperties;

    public SSLGenericServerContainerGroup(String hostname, int port, InetAddress bindAddress, Map defaultContainerProperties) {
        this.serverGroup = new SSLGenericServerSOContainerGroup(hostname, port, bindAddress);
        this.defaultContainerProperties = defaultContainerProperties;
    }

    public SSLGenericServerContainerGroup(String hostname, int port, Map defaultContainerProperties) {
        this(hostname, port, null, defaultContainerProperties);
    }

    private String getHost() {
        return this.serverGroup.getName();
    }

    private int getPort() {
        return this.serverGroup.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getContainers() {
        Map lock;
        HashMap result = new HashMap();
        Map map = lock = this.serverGroup.getMap();
        synchronized (map) {
            Iterator i = lock.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                result.put(key, lock.get(key));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISharedObjectContainer createContainer(String path, int keepAlive, Map properties) throws ContainerCreateException {
        if (path == null) {
            throw new ContainerCreateException("Path for new container cannot be null");
        }
        Map lock = this.serverGroup.getMap();
        SSLServerSOContainer newContainer = null;
        Map map = lock;
        synchronized (map) {
            SSLServerSOContainer existing = (SSLServerSOContainer)lock.get(path);
            if (existing != null) {
                throw new ContainerCreateException("Container with path=" + path + " already exists");
            }
            newContainer = this.createGenericServerContainer(path, keepAlive, properties);
            this.addNewContainerToContainerManager((ISharedObjectContainer)newContainer);
        }
        return newContainer;
    }

    public ISharedObjectContainer createContainer(String path, int keepAlive) throws ContainerCreateException {
        return this.createContainer(path, keepAlive, null);
    }

    private void addNewContainerToContainerManager(ISharedObjectContainer container) {
        IContainerManager containerManager = Activator.getDefault().getContainerManager();
        if (containerManager != null) {
            ContainerTypeDescription ctd = containerManager.getContainerFactory().getDescriptionByName("ecf.generic.server");
            containerManager.addContainer((IContainer)container, ctd);
        }
    }

    private void removeContainerFromContainerManager(ISharedObjectContainer container) {
        IContainerManager containerManager = Activator.getDefault().getContainerManager();
        if (containerManager != null) {
            containerManager.removeContainer((IContainer)container);
        }
    }

    public ISharedObjectContainer createContainer(String path) throws ContainerCreateException {
        return this.createContainer(path, 30000);
    }

    protected SSLServerSOContainerGroup getServerGroup() {
        return this.serverGroup;
    }

    protected SSLServerSOContainer createGenericServerContainer(String path, int keepAlive, Map properties) throws ContainerCreateException {
        try {
            return new SSLServerSOContainer((ISharedObjectContainerConfig)new SOContainerConfig(this.createGenericServerID(path, properties), this.createGenericServerProperties(path, properties)), this.getServerGroup(), path, keepAlive);
        }
        catch (Exception e) {
            throw new ContainerCreateException("Unexpected exception creating generic server container path=" + path, (Throwable)e);
        }
    }

    protected Map createGenericServerProperties(String path, Map properties) {
        return properties == null ? this.defaultContainerProperties : properties;
    }

    protected ID createGenericServerID(String path, Map properties) throws ContainerCreateException {
        if (!path.startsWith("/")) {
            throw new ContainerCreateException("Path must start with '/'");
        }
        String serverIDPrefix = this.createGenericServerIDPrefix();
        return IDFactory.getDefault().createStringID(String.valueOf(serverIDPrefix) + path);
    }

    private String createGenericServerIDPrefix() {
        return "ecfssl://" + this.getHost() + ":" + this.getPort();
    }

    public ISharedObjectContainer getContainer(String path) {
        return this.serverGroup.get(path);
    }

    public ISharedObjectContainer removeContainer(String path) {
        return this.serverGroup.remove(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startListening() throws IOException {
        Map lock;
        Map map = lock = this.serverGroup.getMap();
        synchronized (map) {
            this.serverGroup.putOnTheAir();
        }
    }

    public boolean isListening() {
        return this.serverGroup.isOnTheAir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopListening() {
        Map lock;
        Map map = lock = this.serverGroup.getMap();
        synchronized (map) {
            this.serverGroup.takeOffTheAir();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Map lock;
        Map map = lock = this.serverGroup.getMap();
        synchronized (map) {
            Iterator i = lock.keySet().iterator();
            while (i.hasNext()) {
                SSLServerSOContainer container = (SSLServerSOContainer)this.removeContainer((String)i.next());
                this.removeContainerFromContainerManager((ISharedObjectContainer)container);
                if (container == null) continue;
                container.dispose();
            }
            this.serverGroup.takeOffTheAir();
        }
    }

    public URI getGroupEndpoint() {
        try {
            return new URI(this.createGenericServerIDPrefix());
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public boolean isSSLTransport() {
        return true;
    }

    class SSLGenericServerSOContainerGroup
    extends SSLServerSOContainerGroup {
        public SSLGenericServerSOContainerGroup(String name, int port, InetAddress bindAddress) {
            super(name, null, port, bindAddress);
        }

        public Map getMap() {
            return this.map;
        }
    }
}

