/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.discovery.ui.model.impl;

import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.discovery.ui.model.IHost;
import org.eclipse.ecf.discovery.ui.model.INetwork;
import org.eclipse.ecf.discovery.ui.model.IServiceID;
import org.eclipse.ecf.discovery.ui.model.IServiceTypeID;
import org.eclipse.ecf.discovery.ui.model.ModelFactory;
import org.eclipse.ecf.discovery.ui.model.ModelPackage;
import org.eclipse.ecf.discovery.ui.model.impl.IHostImpl;
import org.eclipse.ecf.discovery.ui.model.impl.INetworkImpl;
import org.eclipse.ecf.discovery.ui.model.impl.IServiceIDImpl;
import org.eclipse.ecf.discovery.ui.model.impl.IServiceInfoImpl;
import org.eclipse.ecf.discovery.ui.model.impl.IServiceTypeIDImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

public class ModelFactoryImpl
extends EFactoryImpl
implements ModelFactory {
    public static ModelFactory init() {
        try {
            ModelFactory theModelFactory = (ModelFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/ecf/discovery.ecore");
            if (theModelFactory != null) {
                return theModelFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new ModelFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createIServiceInfo();
            }
            case 1: {
                return this.createINetwork();
            }
            case 2: {
                return this.createIHost();
            }
            case 3: {
                return this.createIServiceID();
            }
            case 4: {
                return this.createIServiceTypeID();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 5: {
                return this.createECFIServiceInfoFromString(eDataType, initialValue);
            }
            case 6: {
                return this.createInetAddressFromString(eDataType, initialValue);
            }
            case 7: {
                return this.createECFIServiceIDFromString(eDataType, initialValue);
            }
            case 8: {
                return this.createECFIServiceTypeIDFromString(eDataType, initialValue);
            }
            case 9: {
                return this.createURIFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 5: {
                return this.convertECFIServiceInfoToString(eDataType, instanceValue);
            }
            case 6: {
                return this.convertInetAddressToString(eDataType, instanceValue);
            }
            case 7: {
                return this.convertECFIServiceIDToString(eDataType, instanceValue);
            }
            case 8: {
                return this.convertECFIServiceTypeIDToString(eDataType, instanceValue);
            }
            case 9: {
                return this.convertURIToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public org.eclipse.ecf.discovery.ui.model.IServiceInfo createIServiceInfo() {
        IServiceInfoImpl iServiceInfo = new IServiceInfoImpl();
        return iServiceInfo;
    }

    public INetwork createINetwork() {
        INetworkImpl iNetwork = new INetworkImpl();
        return iNetwork;
    }

    public IHost createIHost() {
        IHostImpl iHost = new IHostImpl();
        return iHost;
    }

    public IServiceID createIServiceID() {
        IServiceIDImpl iServiceID = new IServiceIDImpl();
        return iServiceID;
    }

    public IServiceTypeID createIServiceTypeID() {
        IServiceTypeIDImpl iServiceTypeID = new IServiceTypeIDImpl();
        return iServiceTypeID;
    }

    public IServiceInfo createECFIServiceInfoFromString(EDataType eDataType, String initialValue) {
        return (IServiceInfo)super.createFromString(eDataType, initialValue);
    }

    public String convertECFIServiceInfoToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public InetAddress createInetAddressFromString(EDataType eDataType, String initialValue) {
        try {
            return InetAddress.getByName(initialValue);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Invalid value: '" + initialValue + "' for datatype :" + eDataType.getName());
        }
    }

    public String convertInetAddressToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public org.eclipse.ecf.discovery.identity.IServiceID createECFIServiceIDFromString(EDataType eDataType, String initialValue) {
        return (org.eclipse.ecf.discovery.identity.IServiceID)super.createFromString(eDataType, initialValue);
    }

    public String convertECFIServiceIDToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public org.eclipse.ecf.discovery.identity.IServiceTypeID createECFIServiceTypeIDFromString(EDataType eDataType, String initialValue) {
        return (org.eclipse.ecf.discovery.identity.IServiceTypeID)super.createFromString(eDataType, initialValue);
    }

    public String convertECFIServiceTypeIDToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public URI createURIFromString(EDataType eDataType, String initialValue) {
        return (URI)super.createFromString(eDataType, initialValue);
    }

    public String convertURIToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public ModelPackage getModelPackage() {
        return (ModelPackage)this.getEPackage();
    }

    public static ModelPackage getPackage() {
        return ModelPackage.eINSTANCE;
    }
}

