/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.server.generic.app;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.security.IConnectHandlerPolicy;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContainerConfig;
import org.eclipse.ecf.provider.generic.SOContainerConfig;
import org.eclipse.ecf.provider.generic.SSLServerSOContainer;
import org.eclipse.ecf.provider.generic.SSLServerSOContainerGroup;
import org.eclipse.ecf.server.generic.app.Connector;
import org.eclipse.ecf.server.generic.app.NamedGroup;
import org.eclipse.ecf.server.generic.app.ServerConfigParser;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;

public class SSLGenericServer
implements IApplication {
    private static Map serverGroups = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object start(IApplicationContext context) throws Exception {
        try {
            String[] args = this.mungeArguments((String[])context.getArguments().get("application.args"));
            if (args.length == 1 && (args[0].equals("-help") || args[0].equals("-h"))) {
                this.usage();
                return IApplication.EXIT_OK;
            }
            if (args.length == 2 && (args[0].equals("-config") || args[0].equals("-c"))) {
                try (FileInputStream fis = null;){
                    fis = new FileInputStream(args[1]);
                    this.setupServerFromConfig(new ServerConfigParser().load(fis));
                }
            } else {
                String hostname = SSLServerSOContainer.DEFAULT_HOST;
                int port = SSLServerSOContainer.DEFAULT_PORT;
                String name = SSLServerSOContainer.DEFAULT_NAME;
                int keepAlive = SSLServerSOContainer.DEFAULT_KEEPALIVE;
                switch (args.length) {
                    case 4: {
                        keepAlive = Integer.parseInt(args[3]);
                    }
                    case 3: {
                        hostname = args[2];
                    }
                    case 2: {
                        name = args[1];
                        if (!name.startsWith("/")) {
                            name = "/" + name;
                        }
                    }
                    case 1: {
                        port = Integer.parseInt(args[0]);
                    }
                }
                this.setupServerFromParameters(hostname, port, name, keepAlive);
            }
            SSLGenericServer sSLGenericServer = this;
            synchronized (sSLGenericServer) {
                this.wait();
            }
            return IApplication.EXIT_OK;
        }
        catch (Exception e) {
            this.stop();
            throw e;
        }
    }

    private void usage() {
        System.out.println("Usage: eclipse.exe -application " + this.getClass().getName() + "[port [groupname [hostname [keepAlive]]]] | [-config|-c <configfile.xml>]");
        System.out.println("   Examples: eclipse -application org.eclipse.ecf.provider.SSLGenericServer");
        System.out.println("             eclipse -application org.eclipse.ecf.provider.SSLGenericServer 7777");
        System.out.println("             eclipse -application org.eclipse.ecf.provider.SSLGenericServer 7777 mygroup foobarhost.wherever.com 35000");
        System.out.println("             eclipse -application org.eclipse.ecf.provider.SSLGenericServer -c myconfig.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupServerFromParameters(String hostname, int port, String name, int keepAlive) throws IOException, IDCreateException {
        String hostnamePort = String.valueOf(hostname) + ":" + port;
        Map map = serverGroups;
        synchronized (map) {
            SSLServerSOContainerGroup serverGroup = (SSLServerSOContainerGroup)serverGroups.get(hostnamePort);
            if (serverGroup == null) {
                System.out.println("Putting server " + hostnamePort + " on the air...");
                try {
                    serverGroup = new SSLServerSOContainerGroup(hostname, port);
                    String url = "ecfssl://" + hostnamePort + name;
                    SSLServerSOContainer container = SSLGenericServer.createServerContainer(url, serverGroup, name, keepAlive);
                    this.configureServerContainer(container);
                    serverGroup.putOnTheAir();
                }
                catch (IOException e) {
                    e.printStackTrace(System.err);
                    throw e;
                }
                catch (IDCreateException e) {
                    e.printStackTrace(System.err);
                    throw e;
                }
                serverGroups.put(hostnamePort, serverGroup);
                System.out.println("SSLGenericServerContainer " + hostnamePort + " on the air.");
            } else {
                System.out.println("SSLGenericServerContainer " + hostnamePort + " already on the air.  No changes made.");
            }
        }
    }

    protected void configureServerContainer(SSLServerSOContainer container) {
        container.setConnectPolicy((IConnectHandlerPolicy)new JoinListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupServerFromConfig(List connectors) throws IOException, IDCreateException {
        for (Connector connector : connectors) {
            String hostname = connector.getHostname();
            int port = connector.getPort();
            String hostnamePort = String.valueOf(hostname) + ":" + port;
            SSLServerSOContainerGroup serverGroup = null;
            Map map = serverGroups;
            synchronized (map) {
                serverGroup = (SSLServerSOContainerGroup)serverGroups.get(hostnamePort);
                if (serverGroup == null) {
                    System.out.println("Putting server " + hostnamePort + " on the air...");
                    serverGroup = new SSLServerSOContainerGroup(hostname, port);
                    List groups = connector.getGroups();
                    for (NamedGroup group : groups) {
                        SSLServerSOContainer container = SSLGenericServer.createServerContainer(group.getIDForGroup(), serverGroup, group.getName(), connector.getTimeout());
                        this.configureServerContainer(container);
                    }
                    serverGroup.putOnTheAir();
                    serverGroups.put(hostnamePort, serverGroup);
                    System.out.println("GenericServerContainer " + hostnamePort + " on the air.");
                } else {
                    System.out.println("GenericServerContainer " + hostnamePort + " already on the air.  No changes made.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = serverGroups;
        synchronized (object) {
            Iterator i = serverGroups.keySet().iterator();
            while (i.hasNext()) {
                SSLServerSOContainerGroup serverGroup = (SSLServerSOContainerGroup)serverGroups.get(i.next());
                serverGroup.takeOffTheAir();
                System.out.println("Taking " + serverGroup.getName() + ":" + serverGroup.getPort() + " off the air");
                Iterator iter = serverGroup.elements();
                while (iter.hasNext()) {
                    SSLServerSOContainer container = (SSLServerSOContainer)iter.next();
                    container.dispose();
                }
            }
        }
        serverGroups.clear();
        object = this;
        synchronized (object) {
            this.notify();
        }
    }

    private String[] mungeArguments(String[] originalArgs) {
        if (originalArgs == null) {
            return new String[0];
        }
        ArrayList<String> l = new ArrayList<String>();
        int i = 0;
        while (i < originalArgs.length) {
            if (!originalArgs[i].equals("-pdelaunch")) {
                l.add(originalArgs[i]);
            }
            ++i;
        }
        return l.toArray(new String[0]);
    }

    private static SSLServerSOContainer createServerContainer(String id, SSLServerSOContainerGroup group, String path, int keepAlive) throws IDCreateException {
        System.out.println("  Creating container with id=" + id + " keepAlive=" + keepAlive);
        ID newServerID = IDFactory.getDefault().createStringID(id);
        SOContainerConfig config = new SOContainerConfig(newServerID);
        return new SSLServerSOContainer((ISharedObjectContainerConfig)config, group, path, keepAlive);
    }

    static class JoinListener
    implements IConnectHandlerPolicy {
        JoinListener() {
        }

        public PermissionCollection checkConnect(Object addr, ID fromID, ID targetID, String targetGroup, Object joinData) throws Exception {
            System.out.println("CLIENT CONNECT: fromAddress=" + addr + ";fromID=" + fromID + ";targetGroup=" + targetGroup);
            return null;
        }

        public void refresh() {
        }
    }
}

