/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.irc.ui.wizards;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.ecf.internal.irc.ui.Activator;
import org.eclipse.ecf.internal.irc.ui.Messages;
import org.eclipse.ecf.ui.SharedImages;
import org.eclipse.ecf.ui.util.PasswordCacheHelper;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

final class IRCConnectWizardPage
extends WizardPage {
    private Combo connectText;
    private Text passwordText;
    private String authorityAndPath;
    private Combo connectTimeOut;
    private String[] connectTimeOutValues = new String[]{"10", "20", "30", "40", "50", "60"};
    private static final String PAGE_SETTINGS = IRCConnectWizardPage.class.getName();
    private static final int MAX_COMBO_VALUES = 40;
    private static final String COMBO_TEXT_KEY = "connectTextValue";
    private static final String COMBO_BOX_ITEMS_KEY = "comboValues";

    IRCConnectWizardPage() {
        super("IRCConnectWizardPage");
        this.setTitle(Messages.IRCConnectWizardPage_WIZARD_PAGE_TITLE);
        this.setDescription(Messages.IRCConnectWizardPage_WIZARD_PAGE_DESCRIPTION);
        this.setPageComplete(false);
        this.setImageDescriptor(SharedImages.getImageDescriptor((String)"IMG_CHAT_WIZARD"));
    }

    IRCConnectWizardPage(String authorityAndPath) {
        this();
        this.authorityAndPath = authorityAndPath;
    }

    private void verify() {
        String text = this.connectText.getText();
        if (text.equals("")) {
            this.updateStatus(Messages.IRCConnectWizardPage_STATUS_MESSAGE_EMPTY);
        } else if (text.indexOf(64) == -1) {
            this.updateStatus(Messages.IRCConnectWizardPage_STATUS_MESSAGE_MALFORMED);
        } else {
            this.updateStatus(null);
            this.restorePassword(text);
        }
    }

    protected String getPasswordKeyFromUserName(String username) {
        if (username == null || username.equals("")) {
            return null;
        }
        int slashIndex = username.indexOf("/");
        if (slashIndex == -1) {
            return username;
        }
        return username.substring(0, username.indexOf("/"));
    }

    protected void restorePassword(String username) {
        PasswordCacheHelper pwStorage = new PasswordCacheHelper(this.getPasswordKeyFromUserName(username));
        String pw = pwStorage.retrievePassword();
        if (pw != null) {
            this.passwordText.setText(pw);
        }
    }

    public void createControl(Composite parent) {
        parent = new Composite(parent, 0);
        parent.setLayout((Layout)new GridLayout());
        GridData fillData = new GridData(4, 0x1000000, true, false);
        GridData endData = new GridData(4, 0x1000000, true, false, 2, 1);
        Label label = new Label(parent, 16384);
        label.setText(Messages.IRCConnectWizardPage_CONNECTID_LABEL);
        this.connectText = new Combo(parent, 2052);
        this.connectText.setLayoutData((Object)fillData);
        this.connectText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IRCConnectWizardPage.this.verify();
            }
        });
        this.connectText.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                IRCConnectWizardPage.this.verify();
            }

            public void widgetSelected(SelectionEvent e) {
                IRCConnectWizardPage.this.passwordText.setText("");
                IRCConnectWizardPage.this.verify();
            }
        });
        this.connectText.setText(NLS.bind((String)Messages.IRCConnectWizardPage_CONNECTID_DEFAULT, (Object)this.getRandomNumber()));
        label = new Label(parent, 131072);
        label.setText(Messages.IRCConnectWizardPage_CONNECTID_EXAMPLE);
        label.setLayoutData((Object)endData);
        label = new Label(parent, 16384);
        label.setText(Messages.IRCConnectWizardPage_PASSWORD_LABEL);
        this.passwordText = new Text(parent, 0x400804);
        this.passwordText.setLayoutData((Object)fillData);
        label = new Label(parent, 131072);
        label.setText(Messages.IRCConnectWizardPage_PASSWORD_INFO);
        label.setLayoutData((Object)endData);
        this.restoreCombo();
        if (this.authorityAndPath != null) {
            this.connectText.setText(this.authorityAndPath);
            this.restorePassword(this.authorityAndPath);
            this.passwordText.setFocus();
        }
        label.setLayoutData((Object)endData);
        label = new Label(parent, 16384);
        label.setText(Messages.IRCConnectWizardPage_CONNECT_TIMEOUT);
        this.connectTimeOut = new Combo(parent, 2052);
        this.connectTimeOut.setLayoutData((Object)fillData);
        this.connectTimeOut.setItems(this.connectTimeOutValues);
        this.connectTimeOut.select(this.connectTimeOutValues.length - 1);
        this.connectText.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                System.setProperty("org.eclipse.ecf.provider.irc.connectTimeout", IRCConnectWizardPage.this.connectTimeOut.getText());
            }
        });
        label = new Label(parent, 131072);
        label.setText(Messages.IRCConnectWizardPage_CONNECT_TIMEOUT_INFO);
        label.setLayoutData((Object)endData);
        Dialog.applyDialogFont((Control)parent);
        this.setControl((Control)parent);
    }

    private String getRandomNumber() {
        SecureRandom random = new SecureRandom();
        return String.valueOf(random.nextInt(100000));
    }

    String getConnectID() {
        return this.connectText.getText();
    }

    String getPassword() {
        return this.passwordText.getText();
    }

    int getConnectTimeOut() {
        return Integer.parseInt(this.connectTimeOut.getText());
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    protected void saveComboText() {
        IDialogSettings pageSettings = this.getPageSettings();
        if (pageSettings != null) {
            pageSettings.put(COMBO_TEXT_KEY, this.connectText.getText());
        }
    }

    protected void saveComboItems() {
        IDialogSettings pageSettings = this.getPageSettings();
        if (pageSettings != null) {
            String connectTextValue = this.connectText.getText();
            List<String> rawItems = Arrays.asList(this.connectText.getItems());
            ArrayList<String> items = new ArrayList<String>();
            if (!rawItems.contains(connectTextValue)) {
                items.add(connectTextValue);
            }
            items.addAll(rawItems);
            int itemsToSaveLength = items.size();
            if (itemsToSaveLength > 40) {
                itemsToSaveLength = 40;
            }
            String[] itemsToSave = new String[itemsToSaveLength];
            System.arraycopy(items.toArray(new String[0]), 0, itemsToSave, 0, itemsToSaveLength);
            pageSettings.put(COMBO_BOX_ITEMS_KEY, itemsToSave);
        }
    }

    public IDialogSettings getDialogSettings() {
        return Activator.getDefault().getDialogSettings();
    }

    private IDialogSettings getPageSettings() {
        IDialogSettings pageSettings = null;
        IDialogSettings dialogSettings = this.getDialogSettings();
        if (dialogSettings != null) {
            pageSettings = dialogSettings.getSection(PAGE_SETTINGS);
            if (pageSettings == null) {
                pageSettings = dialogSettings.addNewSection(PAGE_SETTINGS);
            }
            return pageSettings;
        }
        return null;
    }

    protected void restoreCombo() {
        IDialogSettings pageSettings = this.getPageSettings();
        if (pageSettings != null) {
            String text;
            String[] items = pageSettings.getArray(COMBO_BOX_ITEMS_KEY);
            if (items != null) {
                this.connectText.setItems(items);
            }
            if ((text = pageSettings.get(COMBO_TEXT_KEY)) != null) {
                this.connectText.setText(text);
            }
        }
    }
}

