/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.zookeeper.node.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.zookeeper.ZooKeeper;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.provider.zookeeper.DiscoveryActivator;
import org.eclipse.ecf.provider.zookeeper.core.AdvertisedService;
import org.eclipse.ecf.provider.zookeeper.core.ZooDiscoveryContainer;
import org.eclipse.ecf.provider.zookeeper.core.internal.BundleStoppingListener;
import org.eclipse.ecf.provider.zookeeper.core.internal.Configuration;
import org.eclipse.ecf.provider.zookeeper.node.internal.NodeWriter;
import org.eclipse.ecf.provider.zookeeper.node.internal.ReadRoot;
import org.eclipse.ecf.provider.zookeeper.node.internal.WriteRoot;
import org.eclipse.ecf.provider.zookeeper.util.Geo;
import org.eclipse.ecf.provider.zookeeper.util.Logger;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WatchManager
implements BundleStoppingListener {
    private List<ZooKeeper> zooKeepers;
    private Map<String, NodeWriter> nodeWriters;
    private Map<String, IServiceInfo> allKnownServices;
    private Configuration config;
    private WriteRoot writeRoot;
    private Lock writeRootLock;
    private boolean isDisposed;

    public WatchManager(Configuration config) {
        this.config = config;
        DiscoveryActivator.registerBundleStoppingListner(this);
        this.zooKeepers = new ArrayList<ZooKeeper>();
        this.nodeWriters = new HashMap<String, NodeWriter>();
        this.allKnownServices = new HashMap<String, IServiceInfo>();
        this.writeRootLock = new Lock().lock();
        this.isDisposed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void publish(ServiceReference ref) {
        Assert.isNotNull((Object)ref);
        String serviceid = ref.getProperty("service.id").toString();
        if (this.getNodeWriters().containsKey(serviceid)) {
            return;
        }
        if (!this.writeRootLock.isOpen()) {
            Lock lock = this.writeRootLock;
            synchronized (lock) {
                try {
                    this.writeRootLock.wait();
                }
                catch (InterruptedException e) {
                    Logger.log(4, e.getMessage(), e);
                }
            }
        }
        AdvertisedService published = new AdvertisedService(ref);
        this.allKnownServices.put(published.getServiceID().getName(), published);
        NodeWriter nodeWriter = new NodeWriter(published, this.writeRoot);
        this.getNodeWriters().put(serviceid, nodeWriter);
        nodeWriter.publish();
    }

    public void publish(AdvertisedService published) {
        Assert.isNotNull((Object)published);
        try {
            while (!this.writeRootLock.isOpen()) {
                Thread.sleep(300L);
            }
        }
        catch (InterruptedException e) {
            Logger.log(4, e.getMessage(), e);
        }
        String serviceName = published.getServiceID().getName();
        NodeWriter nodeWriter = new NodeWriter(published, this.writeRoot);
        this.getNodeWriters().put(serviceName, nodeWriter);
        this.allKnownServices.put(serviceName, published);
        nodeWriter.publish();
    }

    public synchronized void unpublish(String id) {
        Assert.isNotNull((Object)id);
        IServiceInfo p = AdvertisedService.removePublished(id);
        if (p == null) {
            return;
        }
        NodeWriter nw = this.getNodeWriters().remove(id);
        if (nw != null) {
            this.allKnownServices.remove(nw.getNode().getWrappedService().getServiceID().getName());
            nw.remove();
        }
        nw = null;
    }

    public synchronized void update(ServiceReference ref) {
        Assert.isNotNull((Object)ref);
        this.unpublish(ref.getProperty("service.id").toString());
        this.publish(ref);
    }

    public void watch() {
        switch (this.getConfig().getFlavor()) {
            case CENTRALIZED: {
                ZooDiscoveryContainer.CACHED_THREAD_POOL.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        WatchManager.this.writeRoot = new WriteRoot(WatchManager.this.getConfig().getServerIps(), WatchManager.this);
                        Lock lock = WatchManager.this.writeRootLock;
                        synchronized (lock) {
                            WatchManager.this.writeRootLock.unlock();
                            WatchManager.this.writeRootLock.notifyAll();
                        }
                    }
                });
                ZooDiscoveryContainer.CACHED_THREAD_POOL.execute(new Runnable(){

                    public void run() {
                        new ReadRoot(WatchManager.this.getConfig().getServerIps(), WatchManager.this);
                    }
                });
                break;
            }
            case REPLICATED: {
                ZooDiscoveryContainer.CACHED_THREAD_POOL.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        WatchManager.this.writeRoot = new WriteRoot(WatchManager.this.getConfig().getServerIps(), WatchManager.this);
                        Lock lock = WatchManager.this.writeRootLock;
                        synchronized (lock) {
                            WatchManager.this.writeRootLock.unlock();
                            WatchManager.this.writeRootLock.notifyAll();
                        }
                    }
                });
                ZooDiscoveryContainer.CACHED_THREAD_POOL.execute(new Runnable(){

                    public void run() {
                        new ReadRoot(WatchManager.this.getConfig().getServerIps(), WatchManager.this);
                    }
                });
                break;
            }
            case STANDALONE: {
                ZooDiscoveryContainer.CACHED_THREAD_POOL.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Object object;
                        WatchManager.this.writeRoot = new WriteRoot(Geo.getHost(), WatchManager.this);
                        if (!WatchManager.this.writeRoot.isConnected()) {
                            object = WatchManager.this.writeRoot;
                            synchronized (object) {
                                try {
                                    WatchManager.this.writeRoot.wait();
                                }
                                catch (InterruptedException e) {
                                    Logger.log(4, e.getMessage(), e);
                                }
                            }
                        }
                        object = WatchManager.this.writeRootLock;
                        synchronized (object) {
                            WatchManager.this.writeRootLock.unlock();
                            WatchManager.this.writeRootLock.notifyAll();
                        }
                    }
                });
                ZooDiscoveryContainer.CACHED_THREAD_POOL.execute(new Runnable(){

                    public void run() {
                        String[] stringArray = WatchManager.this.getConfig().getServerIps().split(",");
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String ip = stringArray[n2];
                            new ReadRoot(ip, WatchManager.this);
                            ++n2;
                        }
                    }
                });
            }
        }
    }

    @Override
    public void bundleStopping() {
        this.dispose();
    }

    public void dispose() {
        try {
            this.isDisposed = true;
            this.unpublishAll();
            if (!this.getNodeWriters().isEmpty()) {
                HashSet<NodeWriter> copy = new HashSet<NodeWriter>();
                copy.addAll(this.getNodeWriters().values());
                for (NodeWriter nw : copy) {
                    if (!nw.getNode().isLocalNode()) continue;
                    nw.remove();
                }
                copy.clear();
            }
            for (ZooKeeper zk : this.zooKeepers) {
                if (zk == null) continue;
                zk.close();
            }
            if (this.zooKeepers != null) {
                this.zooKeepers.clear();
            }
            if (this.allKnownServices != null) {
                this.allKnownServices.clear();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setConfig(Configuration config) {
        this.config = config;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public void addZooKeeper(ZooKeeper zooKeeper) {
        Assert.isNotNull((Object)zooKeeper);
        this.zooKeepers.add(zooKeeper);
    }

    public void removeZooKeeper(ZooKeeper zooKeeper) {
        this.zooKeepers.remove(zooKeeper);
    }

    public WriteRoot getWriteRoot() {
        return this.writeRoot;
    }

    public Map<String, NodeWriter> getNodeWriters() {
        return this.nodeWriters;
    }

    public void unpublishAll() {
        for (NodeWriter nw : this.getNodeWriters().values()) {
            nw.remove();
            this.allKnownServices.remove(nw.getNode().getWrappedService().getServiceID().getName());
        }
    }

    public void republishAll() {
        NodeWriter[] nws = this.getNodeWriters().values().toArray(new NodeWriter[this.getNodeWriters().size()]);
        int i = 0;
        while (i < nws.length) {
            nws[i].getNode().regenerateNodeId();
            nws[i].publish();
            this.allKnownServices.put(nws[i].getNode().getWrappedService().getServiceID().getName(), nws[i].getNode().getWrappedService());
            ++i;
        }
    }

    public Map<String, IServiceInfo> getAllKnownServices() {
        return this.allKnownServices;
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    private class Lock {
        boolean state;

        private Lock() {
        }

        boolean isOpen() {
            return this.state;
        }

        Lock unlock() {
            this.state = true;
            return this;
        }

        Lock lock() {
            this.state = false;
            return this;
        }
    }
}

