/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.msn;

import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.presence.im.IChatID;

class MSNID
implements IChatID,
ID {
    private static final long serialVersionUID = 902162253789728990L;
    private final Namespace namespace;
    private final String email;
    private final String userName;
    private final String hostName;

    MSNID(Namespace namespace, String email) {
        this.namespace = namespace;
        this.email = email;
        int index = email.indexOf(64);
        this.userName = email.substring(0, index);
        this.hostName = email.substring(index + 1);
    }

    public String getName() {
        return this.email;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public String toExternalForm() {
        return this.email;
    }

    public int compareTo(Object another) {
        if (another instanceof MSNID) {
            return this.email.compareTo(((MSNID)another).email);
        }
        throw new ClassCastException();
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IChatID.class)) {
            return this;
        }
        return null;
    }

    public String getUsername() {
        return this.userName;
    }

    public String getHostname() {
        return this.hostName;
    }

    public int hashCode() {
        return this.email.hashCode() ^ 0xFFFFFFE1;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MSNID) {
            return this.email.equals(((MSNID)obj).email);
        }
        return false;
    }

    public String toString() {
        return this.email;
    }
}

