/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice.soap.client;

import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.remoteservice.IRemoteCall;
import org.eclipse.ecf.remoteservice.IRemoteService;
import org.eclipse.ecf.remoteservice.client.AbstractClientContainer;
import org.eclipse.ecf.remoteservice.client.IRemoteCallable;
import org.eclipse.ecf.remoteservice.client.RemoteServiceClientRegistration;
import org.eclipse.ecf.remoteservice.soap.identity.SoapID;

public abstract class AbstractSoapClientContainer
extends AbstractClientContainer {
    public AbstractSoapClientContainer(SoapID containerID) {
        super((ID)containerID);
    }

    protected abstract IRemoteService createRemoteService(RemoteServiceClientRegistration var1);

    protected String prepareEndpointAddress(IRemoteCall call, IRemoteCallable callable) {
        String resourcePath = callable.getResourcePath();
        if (resourcePath == null || "".equals(resourcePath)) {
            return null;
        }
        if (resourcePath.startsWith("http://")) {
            return resourcePath;
        }
        SoapID targetContainerID = (SoapID)this.getRemoteCallTargetID();
        String baseUriString = targetContainerID.toURI().toString();
        int length = baseUriString.length();
        char[] lastChar = new char[1];
        baseUriString.getChars(length - 1, length, lastChar, 0);
        char[] firstMethodChar = new char[1];
        resourcePath.getChars(0, 1, firstMethodChar, 0);
        if (lastChar[0] == '/' && firstMethodChar[0] != '/' || lastChar[0] != '/' && firstMethodChar[0] == '/') {
            return String.valueOf(baseUriString) + resourcePath;
        }
        if (lastChar[0] == '/' && firstMethodChar[0] == '/') {
            String tempurl = baseUriString.substring(0, length - 1);
            return String.valueOf(tempurl) + resourcePath;
        }
        if (lastChar[0] != '/' && firstMethodChar[0] != '/') {
            return String.valueOf(baseUriString) + "/" + resourcePath;
        }
        return null;
    }

    public Namespace getConnectNamespace() {
        return IDFactory.getDefault().getNamespaceByName("ecf.soap.namespace");
    }
}

