/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.examples.internal.remoteservices.hello.ds.consumer;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ecf.examples.remoteservices.hello.IHello;
import org.eclipse.ecf.examples.remoteservices.hello.IHelloAsync;
import org.eclipse.ecf.remoteservice.IAsyncCallback;
import org.eclipse.ecf.remoteservice.IRemoteService;
import org.eclipse.ecf.remoteservice.IRemoteServiceProxy;
import org.eclipse.ecf.remoteservice.RemoteServiceHelper;
import org.eclipse.equinox.concurrent.future.IFuture;

public class HelloClientComponent {
    private static final String CONSUMER_NAME = "helloclientcomponent";

    public void bindHello(IHello proxy) {
        System.out.println("Got proxy IHello=" + proxy);
        System.out.println("STARTING remote call via proxy...");
        proxy.hello("helloclientcomponent via proxy");
        System.out.println("COMPLETED remote call via proxy");
        System.out.println();
        if (proxy instanceof IHelloAsync) {
            IHelloAsync helloA = (IHelloAsync)proxy;
            IAsyncCallback<String> callback = new IAsyncCallback<String>(){

                public void onSuccess(String result) {
                    System.out.println(new StringBuffer("COMPLETED remote call with callback SUCCESS with result=").append(result).toString());
                    System.out.println();
                }

                public void onFailure(Throwable t) {
                    System.out.println(new StringBuffer("COMPLETED remote call with callback FAILED with exception=").append(t).toString());
                    System.out.println();
                }
            };
            System.out.println("STARTING async remote call via callback...");
            helloA.helloAsync("helloclientcomponent via async proxy with listener", (IAsyncCallback)callback);
            System.out.println("LOCAL async invocation complete");
            System.out.println();
            System.out.println("STARTING async remote call via future...");
            Future future = helloA.helloAsync("helloclientcomponent via async proxy with future");
            System.out.println("LOCAL async future invocation complete");
            System.out.println();
            try {
                while (!future.isDone()) {
                    System.out.println("LOCAL future not yet done...so we're doing other stuff while waiting for future to be done");
                    Thread.sleep(200L);
                }
                String result = (String)future.get();
                System.out.println("COMPLETED remote call with future SUCCEEDED with result=" + result);
                System.out.println();
            }
            catch (OperationCanceledException e) {
                System.out.println("COMPLETED remote call with callback CANCELLED with exception=" + (Object)((Object)e));
                System.out.println();
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                System.out.println("COMPLETED remote call with callback INTERRUPTED with exception=" + e);
                System.out.println();
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                System.out.println("COMPLETED remote call with callback INTERRUPTED with exception=" + e);
                System.out.println();
                e.printStackTrace();
            }
        }
        IRemoteService remoteService = ((IRemoteServiceProxy)proxy).getRemoteService();
        Assert.isNotNull((Object)remoteService);
        System.out.println("STARTING async remote call via future...");
        IFuture future = RemoteServiceHelper.futureExec((IRemoteService)remoteService, (String)"hello", (Object[])new Object[]{"helloclientcomponent future"});
        System.out.println("LOCAL async future invocation complete");
        System.out.println();
        try {
            while (!future.isDone()) {
                System.out.println("LOCAL future not yet done...so we're doing other stuff while waiting for future to be done");
                Thread.sleep(200L);
            }
            Object result = future.get();
            System.out.println("COMPLETED remote call with future SUCCEEDED with result=" + result);
            System.out.println();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

