/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.ai.mcp.tools.util;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.ecf.ai.mcp.tools.annotation.Tool;
import org.eclipse.ecf.ai.mcp.tools.annotation.ToolAnnotations;
import org.eclipse.ecf.ai.mcp.tools.util.ToolAnnotationDescription;
import org.eclipse.ecf.ai.mcp.tools.util.ToolParamDescription;
import org.eclipse.ecf.ai.mcp.tools.util.ToolResultDescription;

public record ToolDescription(String name, String description, List<ToolParamDescription> toolParamDescriptions, ToolResultDescription resultDescriptions, List<ToolAnnotationDescription> toolAnnotationDescriptions) {
    public static List<ToolDescription> fromClass(Class<?> clazz) {
        return Arrays.asList(clazz.getMethods()).stream().map(m -> {
            Tool ma;
            if (!Modifier.isStatic(m.getModifiers()) && (ma = m.getAnnotation(Tool.class)) != null) {
                ToolAnnotations tas = m.getAnnotation(ToolAnnotations.class);
                return new ToolDescription(m.getName(), ma.description(), ToolParamDescription.fromParameters(m.getParameters()), ToolResultDescription.fromMethod(m), ToolAnnotationDescription.fromAnnotations(tas != null ? tas.value() : null));
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static List<ToolDescription> fromService(Object svc, String serviceClass) {
        Optional<Class> optClass = Arrays.asList(svc.getClass().getInterfaces()).stream().filter(c -> c.getName().equals(serviceClass)).findFirst();
        return optClass.isPresent() ? ToolDescription.fromClass(optClass.get()) : Collections.emptyList();
    }
}

