/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.remoteservice;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.util.LogHelper;
import org.eclipse.ecf.core.util.SystemLogService;
import org.eclipse.ecf.remoteservice.IRemoteServiceProxyCreator;
import org.eclipse.ecf.remoteservice.RemoteServiceNamespace;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    public static final String PLUGIN_ID = "org.eclipse.ecf.remoteservice";
    private static Activator plugin;
    private BundleContext context;
    private ServiceTracker logServiceTracker = null;
    private LogService logService = null;
    private ServiceRegistration remoteServiceProxyCreator;
    private RemoteServiceNamespace remoteServiceNamespace;

    public Activator() {
        plugin = this;
    }

    public BundleContext getContext() {
        return this.context;
    }

    public void start(BundleContext c) throws Exception {
        this.context = c;
        Hashtable<String, Integer> props = new Hashtable<String, Integer>();
        ((Dictionary)props).put("service.ranking", Integer.MIN_VALUE);
        this.remoteServiceProxyCreator = this.context.registerService(new String[]{IRemoteServiceProxyCreator.class.getName()}, (Object)new IRemoteServiceProxyCreator(){

            public Object createProxy(ClassLoader classloader, Class[] interfaces, InvocationHandler handler) {
                return Proxy.newProxyInstance(classloader, interfaces, handler);
            }
        }, props);
        this.remoteServiceNamespace = new RemoteServiceNamespace("ecf.namespace.remoteservice", "remote service namespace");
        IDFactory.getDefault().addNamespace((Namespace)this.remoteServiceNamespace);
    }

    public void stop(BundleContext c) throws Exception {
        if (this.remoteServiceProxyCreator != null) {
            this.remoteServiceProxyCreator.unregister();
            this.remoteServiceProxyCreator = null;
        }
        if (this.logServiceTracker != null) {
            this.logServiceTracker.close();
            this.logServiceTracker = null;
            this.logService = null;
        }
        if (this.remoteServiceNamespace != null) {
            IDFactory.getDefault().removeNamespace((Namespace)this.remoteServiceNamespace);
            this.remoteServiceNamespace = null;
        }
        this.context = null;
        plugin = null;
    }

    public static synchronized Activator getDefault() {
        if (plugin == null) {
            plugin = new Activator();
        }
        return plugin;
    }

    protected LogService getLogService() {
        if (this.logServiceTracker == null) {
            this.logServiceTracker = new ServiceTracker(this.context, LogService.class.getName(), null);
            this.logServiceTracker.open();
        }
        this.logService = (LogService)this.logServiceTracker.getService();
        if (this.logService == null) {
            this.logService = new SystemLogService(PLUGIN_ID);
        }
        return this.logService;
    }

    public void log(IStatus status) {
        if (this.logService == null) {
            this.logService = this.getLogService();
        }
        if (this.logService != null) {
            this.logService.log(LogHelper.getLogCode((IStatus)status), LogHelper.getLogMessage((IStatus)status), status.getException());
        }
    }
}

