/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.graphics.ColorUtil;

public class Color
extends Resource {
    private int colorNr;

    private Color(int colorNr) {
        super(null);
        this.colorNr = colorNr;
    }

    public Color(Device device, RGB rgb) {
        super(Color.checkDevice(device));
        if (rgb == null) {
            SWT.error(4);
        }
        this.colorNr = ColorUtil.computeColorNr(rgb.red, rgb.green, rgb.blue);
    }

    public Color(Device device, int red, int green, int blue) {
        super(Color.checkDevice(device));
        this.colorNr = ColorUtil.computeColorNr(red, green, blue);
    }

    public int getBlue() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return (this.colorNr & 0xFF0000) >> 16;
    }

    public int getGreen() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return (this.colorNr & 0xFF00) >> 8;
    }

    public int getRed() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.colorNr & 0xFF;
    }

    public RGB getRGB() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return new RGB(this.getRed(), this.getGreen(), this.getBlue());
    }

    public boolean equals(Object object) {
        boolean result;
        if (object == this) {
            result = true;
        } else if (object instanceof Color) {
            Color color = (Color)object;
            result = color.colorNr == this.colorNr;
        } else {
            result = false;
        }
        return result;
    }

    public int hashCode() {
        return this.colorNr;
    }

    public String toString() {
        String result = this.isDisposed() ? "Color {*DISPOSED*}" : "Color {" + this.getRed() + ", " + this.getGreen() + ", " + this.getBlue() + "}";
        return result;
    }
}

