/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.resolver.util;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;

public class CopyOnWriteList<T>
extends AbstractList<T> {
    Object[] data;

    public CopyOnWriteList() {
        this.data = new Object[0];
    }

    public CopyOnWriteList(Collection<T> col) {
        this.data = col instanceof CopyOnWriteList ? ((CopyOnWriteList)col).data : col.toArray(new Object[col.size()]);
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public T get(int index) {
        return (T)this.data[index];
    }

    @Override
    public T set(int index, T element) {
        this.data = Arrays.copyOf(this.data, this.data.length);
        Object prev = this.data[index];
        this.data[index] = element;
        return (T)prev;
    }

    @Override
    public void add(int index, T element) {
        Object[] elements = this.data;
        int len = elements.length;
        Object[] newElements = new Object[len + 1];
        int numMoved = len - index;
        if (index > 0) {
            System.arraycopy(elements, 0, newElements, 0, index);
        }
        if (numMoved > 0) {
            System.arraycopy(elements, index, newElements, index + 1, numMoved);
        }
        newElements[index] = element;
        this.data = newElements;
    }

    @Override
    public T remove(int index) {
        Object[] elements = this.data;
        int len = elements.length;
        Object oldValue = elements[index];
        Object[] newElements = new Object[len - 1];
        int numMoved = len - index - 1;
        if (index > 0) {
            System.arraycopy(elements, 0, newElements, 0, index);
        }
        if (numMoved > 0) {
            System.arraycopy(elements, index + 1, newElements, index, numMoved);
        }
        this.data = newElements;
        return (T)oldValue;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.data);
    }
}

