/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.contexts;

import java.lang.ref.Reference;
import java.util.Objects;
import java.util.Set;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.core.internal.contexts.Computation;
import org.eclipse.e4.core.internal.contexts.ContextChangeEvent;
import org.eclipse.e4.core.internal.contexts.EclipseContext;
import org.eclipse.e4.core.internal.contexts.RunAndTrackExt;

public class TrackableComputationExt
extends Computation {
    private final IEclipseContext originatingContext;
    private final RunAndTrack runnable;
    private ContextChangeEvent cachedEvent;

    public TrackableComputationExt(RunAndTrack runnable, IEclipseContext originatingContext) {
        this.runnable = runnable;
        this.originatingContext = originatingContext;
        this.init();
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    protected int calcHashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.originatingContext);
        return 31 * result + Objects.hashCode(this.runnable);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TrackableComputationExt other = (TrackableComputationExt)obj;
        return Objects.equals(this.originatingContext, other.originatingContext) && Objects.equals(this.runnable, other.runnable);
    }

    @Override
    public void handleInvalid(ContextChangeEvent event, Set<EclipseContext.Scheduled> scheduledList) {
        int eventType = event.getEventType();
        if (eventType == 0 || eventType == 3) {
            this.update(event);
        } else {
            scheduledList.add(new EclipseContext.Scheduled(this, event));
        }
    }

    public boolean update(ContextChangeEvent event) {
        int eventType = event.getEventType();
        if (this.runnable instanceof RunAndTrackExt && ((RunAndTrackExt)this.runnable).batchProcess() && (eventType == 1 || eventType == 2)) {
            this.cachedEvent = event;
            EclipseContext eventsContext = (EclipseContext)event.getContext();
            eventsContext.addWaiting(this);
            return true;
        }
        ((EclipseContext)this.originatingContext).pushComputation(this);
        boolean result = true;
        try {
            if (this.cachedEvent != null) {
                if (this.runnable instanceof RunAndTrackExt) {
                    result = ((RunAndTrackExt)this.runnable).update(event.getContext(), event.getEventType(), event.getArguments());
                    if (eventType != 3 && eventType != 4) {
                        this.cachedEvent = null;
                    }
                } else if (eventType != 3 && eventType != 4) {
                    result = this.runnable.changed(this.originatingContext);
                    this.cachedEvent = null;
                }
            }
            if (eventType != 5) {
                if (this.runnable instanceof RunAndTrackExt) {
                    result = ((RunAndTrackExt)this.runnable).update(event.getContext(), event.getEventType(), event.getArguments());
                } else if (eventType != 3 && eventType != 4) {
                    result = this.runnable.changed(this.originatingContext);
                }
            }
        }
        finally {
            ((EclipseContext)this.originatingContext).popComputation(this);
        }
        EclipseContext eventsContext = (EclipseContext)event.getContext();
        if (eventType == 3 && this.originatingContext.equals(eventsContext)) {
            ((EclipseContext)this.originatingContext).removeRAT(this);
            return false;
        }
        if (!result) {
            ((EclipseContext)this.originatingContext).removeRAT(this);
        }
        return result;
    }

    public String toString() {
        return this.runnable.toString();
    }

    public Reference<Object> getReference() {
        if (this.runnable instanceof RunAndTrackExt) {
            return ((RunAndTrackExt)this.runnable).getReference();
        }
        return null;
    }
}

