/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.theme;

import org.eclipse.rap.rwt.internal.theme.CssColor;
import org.eclipse.rap.rwt.internal.theme.CssValue;

public class CssShadow
implements CssValue {
    public static final CssShadow NONE = new CssShadow(false, 0, 0, 0, 0, null, 0.0f);
    public final boolean inset;
    public final int offsetX;
    public final int offsetY;
    public final int blur;
    public final int spread;
    public final String color;
    public final float opacity;

    private CssShadow(boolean inset, int offsetX, int offsetY, int blur, int spread, String color, float opacity) {
        this.inset = inset;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.blur = blur;
        this.spread = spread;
        this.color = color;
        this.opacity = opacity;
    }

    public static CssShadow create(boolean inset, int offsetX, int offsetY, int blur, int spread, CssColor color) {
        if (blur < 0) {
            String message = "Shadow blur distance can't be negative";
            throw new IllegalArgumentException(message);
        }
        if (spread != 0) {
            String message = "Shadow spread distance is not supported";
            throw new IllegalArgumentException(message);
        }
        if (color == null) {
            throw new NullPointerException("null argument");
        }
        String htmlColor = CssColor.toHtmlString(color.red, color.green, color.blue);
        return new CssShadow(inset, offsetX, offsetY, blur, spread, htmlColor, color.alpha);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof CssShadow) {
            CssShadow other = (CssShadow)object;
            return other.inset == this.inset && other.offsetX == this.offsetX && other.offsetY == this.offsetY && other.blur == this.blur && other.spread == this.spread && (this.color == null ? other.color == null : this.color.equals(other.color)) && other.opacity == this.opacity;
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result += 11 * result + this.offsetX;
        result += 11 * result + this.offsetY;
        result += 11 * result + this.blur;
        result += 11 * result + this.spread;
        if (this.color != null) {
            result += 11 * result + this.color.hashCode();
        }
        result += 11 * result + Float.floatToIntBits(this.opacity);
        return result += this.inset ? 0 : 11 * result + 13;
    }

    @Override
    public String toDefaultString() {
        if (this.color == null) {
            return "none";
        }
        CssColor qxColor = CssColor.valueOf(this.color);
        StringBuilder buffer = new StringBuilder();
        if (this.inset) {
            buffer.append("inset ");
        }
        return buffer.append(this.offsetX).append("px ").append(this.offsetY).append("px ").append(this.blur).append("px ").append(this.spread).append("px ").append("rgba( ").append(qxColor.red).append(", ").append(qxColor.green).append(", ").append(qxColor.blue).append(", ").append(this.opacity).append(" )").toString();
    }

    public String toString() {
        return "CssShadow{ " + this.inset + ", " + this.offsetX + ", " + this.offsetY + ", " + this.blur + ", " + this.spread + ", " + this.color + ", " + this.opacity + " }";
    }
}

