/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class TabFolderTab
extends ExampleTab {
    protected static final int MAX_ITEMS = 3;
    private boolean onDemandContent;
    private TabFolder folder;
    private Button[] tabRadios;
    private int counter;

    public TabFolderTab() {
        super("TabFolder");
    }

    @Override
    protected void createStyleControls(Composite parent) {
        this.createStyleButton("BORDER", 2048);
        this.createStyleButton("TOP", 128);
        this.createStyleButton("BOTTOM", 1024);
        this.createOrientationButton();
        this.createVisibilityButton();
        this.createEnablementButton();
        this.createOnDemandButton(parent);
        this.createFgColorButton();
        this.createBgColorButton();
        this.createFontChooser();
        this.tabRadios = new Button[3];
        int i = 0;
        while (i < 3) {
            this.tabRadios[i] = this.createPropertyButton("Select TabItem at index " + i, 16);
            final int itemIndex = i;
            this.tabRadios[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Button radio = (Button)event.getSource();
                    if (radio.getSelection()) {
                        TabFolderTab.this.folder.setSelection(itemIndex);
                    }
                }
            });
            ++i;
        }
        this.tabRadios[0].setSelection(true);
        this.createChangeContentButton(parent);
        this.createInsertItemButton(parent);
        this.createDisposeSelectedItemButton(parent);
        this.createDisposeFirstItemButton(parent);
        this.createSetFirstItemBadge(parent);
    }

    @Override
    protected void createExampleControls(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.counter = 0;
        this.folder = new TabFolder(parent, this.getStyle());
        this.folder.setToolTipText("Tab Folder Tooltip");
        this.folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TabItem item = (TabItem)event.item;
                if (TabFolderTab.this.tabRadios != null) {
                    int index = item.getParent().indexOf(item);
                    int i = 0;
                    while (i < 3) {
                        if (TabFolderTab.this.checkControl((Control)TabFolderTab.this.tabRadios[i])) {
                            TabFolderTab.this.tabRadios[i].setSelection(index == i);
                        }
                        ++i;
                    }
                }
                if (item.getData("id") == null) {
                    item.setData("id", (Object)TabFolderTab.this.counter);
                }
                TabFolderTab.this.createItemContent(item);
            }
        });
        int i = 0;
        while (i < 3) {
            TabItem item = new TabItem(this.folder, 0);
            item.setData("id", (Object)this.counter);
            item.setText("TabItem " + this.counter);
            item.setImage(this.loadImage("resources/newfolder_wiz.gif"));
            item.setToolTipText("Tooltip for TabItem " + this.counter);
            ++this.counter;
            if (!this.onDemandContent) {
                this.createItemContent(item);
            }
            ++i;
        }
        this.registerControl((Control)this.folder);
    }

    private void createOnDemandButton(Composite parent) {
        Button button = new Button(parent, 32);
        button.setText("Create Item Content on Demand");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button button = (Button)event.widget;
                TabFolderTab.this.onDemandContent = button.getSelection();
                TabFolderTab.this.createNew();
            }
        });
    }

    private void createChangeContentButton(Composite parent) {
        Button btnChangeContent = new Button(parent, 8);
        btnChangeContent.setText("Change Content for Selected Item");
        btnChangeContent.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TabItem item = TabFolderTab.this.folder.getSelection()[0];
                Label content = new Label((Composite)TabFolderTab.this.folder, 0);
                int index = TabFolderTab.this.folder.indexOf(item);
                content.setText("Alternate content for tab item " + index);
                item.setControl((Control)content);
            }
        });
    }

    private void createInsertItemButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Insert item before first item");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TabItem item = new TabItem(TabFolderTab.this.folder, 0, 0);
                item.setData("id", (Object)TabFolderTab.this.counter);
                item.setText("TabItem " + TabFolderTab.this.counter);
                item.setToolTipText("Tooltip for TabItem " + TabFolderTab.this.counter);
                ++TabFolderTab.this.counter;
                if (!TabFolderTab.this.onDemandContent) {
                    TabFolderTab.this.createItemContent(item);
                }
            }
        });
    }

    private void createDisposeSelectedItemButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Dispose selected item");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TabItem[] selection = TabFolderTab.this.folder.getSelection();
                if (selection.length > 0) {
                    selection[0].dispose();
                }
            }
        });
    }

    private void createDisposeFirstItemButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Dispose first item");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (TabFolderTab.this.folder.getItemCount() > 0) {
                    TabFolderTab.this.folder.getItem(0).dispose();
                }
            }
        });
    }

    private void createSetFirstItemBadge(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        new Label(composite, 0).setText("Badge:");
        final Text text = new Text(composite, 2048);
        Listener setBadgeListener = new Listener(){

            public void handleEvent(Event event) {
                if (TabFolderTab.this.folder.getItemCount() > 0) {
                    TabFolderTab.this.folder.getItem(0).setData("org.eclipse.rap.rwt.badge", (Object)text.getText());
                }
            }
        };
        Button button = new Button(composite, 8);
        button.setText("Set");
        button.addListener(13, setBadgeListener);
        text.addListener(14, setBadgeListener);
    }

    private void createItemContent(TabItem item) {
        if (item.getControl() == null) {
            TabFolder folder = item.getParent();
            Text content = new Text((Composite)folder, 74);
            String text = "This is the content for TabItem " + item.getData("id");
            if (this.onDemandContent) {
                text = String.valueOf(text) + "\nIt was created on demand, when the item was selected for the first time through user interaction.";
            }
            content.setText(text);
            item.setControl((Control)content);
        }
    }
}

