/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.emf.internal.xpath;

import java.util.Objects;
import org.eclipse.e4.emf.internal.xpath.helper.ValueUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rap.e4.apache.jxpath.AbstractFactory;
import org.eclipse.rap.e4.apache.jxpath.JXPathAbstractFactoryException;
import org.eclipse.rap.e4.apache.jxpath.JXPathContext;
import org.eclipse.rap.e4.apache.jxpath.JXPathIntrospector;
import org.eclipse.rap.e4.apache.jxpath.ri.QName;
import org.eclipse.rap.e4.apache.jxpath.ri.model.NodePointer;

public abstract class EStructuralFeaturePointer
extends NodePointer {
    private static final long serialVersionUID = 1L;
    public static final int UNSPECIFIED_PROPERTY = Integer.MIN_VALUE;
    protected int propertyIndex = Integer.MIN_VALUE;
    protected Object bean;
    private static final Object UNINITIALIZED = new Object();
    private Object value = UNINITIALIZED;

    public EStructuralFeaturePointer(NodePointer parent) {
        super(parent);
    }

    public int getPropertyIndex() {
        return this.propertyIndex;
    }

    public void setPropertyIndex(int index) {
        if (this.propertyIndex != index) {
            this.propertyIndex = index;
            this.setIndex(Integer.MIN_VALUE);
        }
    }

    public EObject getBean() {
        if (this.bean == null) {
            this.bean = this.getImmediateParentPointer().getNode();
        }
        return (EObject)this.bean;
    }

    @Override
    public QName getName() {
        return new QName(null, this.getPropertyName());
    }

    public abstract String getPropertyName();

    public abstract void setPropertyName(String var1);

    public abstract int getPropertyCount();

    public abstract String[] getPropertyNames();

    protected abstract boolean isActualProperty();

    @Override
    public boolean isActual() {
        if (!this.isActualProperty()) {
            return false;
        }
        return super.isActual();
    }

    @Override
    public Object getImmediateNode() {
        if (this.value == UNINITIALIZED) {
            this.value = this.index == Integer.MIN_VALUE ? ValueUtils.getValue(this.getBaseValue()) : ValueUtils.getValue(this.getBaseValue(), this.index);
        }
        return this.value;
    }

    @Override
    public boolean isCollection() {
        Object value = this.getBaseValue();
        return value != null && ValueUtils.isCollection(value);
    }

    @Override
    public boolean isLeaf() {
        Object value = this.getNode();
        return value == null || JXPathIntrospector.getBeanInfo(value.getClass()).isAtomic();
    }

    @Override
    public int getLength() {
        return ValueUtils.getLength(this.getBaseValue());
    }

    @Override
    public NodePointer getImmediateValuePointer() {
        return NodePointer.newChildNodePointer((NodePointer)this.clone(), this.getName(), this.getImmediateNode());
    }

    @Override
    public NodePointer createPath(JXPathContext context) {
        if (this.getImmediateNode() == null) {
            AbstractFactory factory = this.getAbstractFactory(context);
            int inx = this.index == Integer.MIN_VALUE ? 0 : this.index;
            boolean success = factory.createObject(context, this, this.getBean(), this.getPropertyName(), inx);
            if (!success) {
                throw new JXPathAbstractFactoryException("Factory " + factory + " could not create an object for path: " + this.asPath());
            }
        }
        return this;
    }

    @Override
    public NodePointer createPath(JXPathContext context, Object value) {
        if (this.index != Integer.MIN_VALUE && this.index >= this.getLength()) {
            this.createPath(context);
        }
        this.setValue(value);
        return this;
    }

    @Override
    public NodePointer createChild(JXPathContext context, QName name, int index, Object value) {
        EStructuralFeaturePointer prop = (EStructuralFeaturePointer)this.clone();
        if (name != null) {
            prop.setPropertyName(name.toString());
        }
        prop.setIndex(index);
        return prop.createPath(context, value);
    }

    @Override
    public NodePointer createChild(JXPathContext context, QName name, int index) {
        EStructuralFeaturePointer prop = (EStructuralFeaturePointer)this.clone();
        if (name != null) {
            prop.setPropertyName(name.toString());
        }
        prop.setIndex(index);
        return prop.createPath(context);
    }

    public int hashCode() {
        return this.getImmediateParentPointer().hashCode() + this.propertyIndex + this.index;
    }

    public boolean equals(Object object) {
        int iOther;
        if (object == this) {
            return true;
        }
        if (!(object instanceof EStructuralFeaturePointer)) {
            return false;
        }
        EStructuralFeaturePointer other = (EStructuralFeaturePointer)object;
        if (!Objects.equals(this.parent, other.parent)) {
            return false;
        }
        if (this.getPropertyIndex() != other.getPropertyIndex() || !this.getPropertyName().equals(other.getPropertyName())) {
            return false;
        }
        int iThis = this.index == Integer.MIN_VALUE ? 0 : this.index;
        int n = iOther = other.index == Integer.MIN_VALUE ? 0 : other.index;
        return iThis == iOther;
    }

    @Override
    public int compareChildNodePointers(NodePointer pointer1, NodePointer pointer2) {
        return this.getValuePointer().compareChildNodePointers(pointer1, pointer2);
    }
}

