/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import org.eclipse.core.databinding.observable.IDiff;
import org.eclipse.core.databinding.property.IProperty;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.NativePropertyListener;
import org.eclipse.core.internal.databinding.beans.BeanPropertyListenerSupport;

public abstract class BeanPropertyListener
extends NativePropertyListener
implements PropertyChangeListener {
    private final PropertyDescriptor propertyDescriptor;

    protected BeanPropertyListener(IProperty property, PropertyDescriptor propertyDescriptor, ISimplePropertyListener listener) {
        super(property, listener);
        this.propertyDescriptor = propertyDescriptor;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == null || this.propertyDescriptor.getName().equals(evt.getPropertyName())) {
            Object oldValue = evt.getOldValue();
            Object newValue = evt.getNewValue();
            IDiff diff = evt.getPropertyName() == null || oldValue == null || newValue == null ? null : this.computeDiff(oldValue, newValue);
            this.fireChange(evt.getSource(), diff);
        }
    }

    protected abstract IDiff computeDiff(Object var1, Object var2);

    protected void doAddTo(Object source) {
        BeanPropertyListenerSupport.hookListener(source, this.propertyDescriptor.getName(), this);
    }

    protected void doRemoveFrom(Object source) {
        BeanPropertyListenerSupport.unhookListener(source, this.propertyDescriptor.getName(), this);
    }
}

