/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.apache.batik.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import org.eclipse.rwt.apache.batik.util.io.CharDecoder;

public abstract class AbstractCharDecoder
implements CharDecoder {
    protected static final int BUFFER_SIZE = 8192;
    protected InputStream inputStream;
    protected byte[] buffer = new byte[8192];
    protected int position;
    protected int count;

    protected AbstractCharDecoder(InputStream is) {
        this.inputStream = is;
    }

    public void dispose() throws IOException {
        this.inputStream.close();
        this.inputStream = null;
    }

    protected void fillBuffer() throws IOException {
        this.count = this.inputStream.read(this.buffer, 0, 8192);
        this.position = 0;
    }

    protected void charError(String encoding) throws IOException {
        String pattern = "The input stream represents an invalid {0} stream.";
        Object[] arguments = new Object[]{encoding};
        String mesg = MessageFormat.format(pattern, arguments);
        throw new IOException(mesg);
    }

    protected void endOfStreamError(String encoding) throws IOException {
        String pattern = "Unexpected end of stream while decoding a {0} stream.";
        Object[] arguments = new Object[]{encoding};
        String mesg = MessageFormat.format(pattern, arguments);
        throw new IOException(mesg);
    }
}

