/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.tools.launch.rwt.internal.delegate;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.JavaLaunchDelegate;
import org.eclipse.jdt.launching.SocketUtil;
import org.eclipse.rap.tools.launch.rwt.internal.config.RWTLaunchConfig;
import org.eclipse.rap.tools.launch.rwt.internal.delegate.BrowserOpener;
import org.eclipse.rap.tools.launch.rwt.internal.delegate.LaunchCleanup;
import org.eclipse.rap.tools.launch.rwt.internal.delegate.LaunchTerminator;
import org.eclipse.rap.tools.launch.rwt.internal.delegate.RWTLaunch;
import org.eclipse.rap.tools.launch.rwt.internal.delegate.WebXmlProvider;
import org.eclipse.rap.tools.launch.rwt.internal.util.BundleFileLocator;
import org.eclipse.rap.tools.launch.rwt.internal.util.StringUtil;

public class RWTLaunchDelegate
extends JavaLaunchDelegate {
    private static final String VMARG_JETTY_HOME = " -Djetty.home=";
    private static final String VMARG_DEVELOPMENT_MODE = " -Dorg.eclipse.rap.rwt.developmentMode=";
    private RWTLaunch launch;

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor mon) throws CoreException {
        IProgressMonitor monitor = mon == null ? new NullProgressMonitor() : mon;
        this.initializeLaunch(launch);
        LaunchCleanup.register(launch);
        RWTLaunchConfig launchConfig = this.launch.getLaunchConfig();
        if (launchConfig.getOpenBrowser()) {
            BrowserOpener browserOpener = new BrowserOpener(launch);
            browserOpener.scheduleOpen();
        }
        LaunchTerminator.terminatePrevious(launch, monitor);
        new WebXmlProvider(this.launch).provide(monitor);
        if (!monitor.isCanceled()) {
            super.launch(configuration, mode, launch, mon);
        }
    }

    public String getMainTypeName(ILaunchConfiguration configuration) {
        return "org.eclipse.rap.tools.launch.rwt.internal.jetty.JettyLauncher";
    }

    public String[] getClasspath(ILaunchConfiguration configuration) throws CoreException {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(super.getClasspath(configuration)));
        list.add(BundleFileLocator.locate("org.eclipse.rap.tools.launch.rwt"));
        list.add(BundleFileLocator.locate("org.eclipse.jetty.http"));
        list.add(BundleFileLocator.locate("org.eclipse.jetty.io"));
        list.add(BundleFileLocator.locate("org.eclipse.jetty.security"));
        list.add(BundleFileLocator.locate("org.eclipse.jetty.server"));
        list.add(BundleFileLocator.locate("org.eclipse.jetty.servlet"));
        list.add(BundleFileLocator.locate("org.eclipse.jetty.servlet-api"));
        list.add(BundleFileLocator.locate("org.eclipse.jetty.util"));
        list.add(BundleFileLocator.locate("org.eclipse.jetty.util.ajax"));
        list.add(BundleFileLocator.locate("org.eclipse.jetty.webapp"));
        list.add(BundleFileLocator.locate("org.eclipse.jetty.xml"));
        list.add(BundleFileLocator.locate("slf4j.api"));
        return list.toArray(new String[0]);
    }

    public String getProgramArguments(ILaunchConfiguration configuration) {
        String port = String.valueOf(this.launch.getPort());
        String contextPath = this.getContextPath();
        String webAppDirectory = this.launch.getWebAppPath().getAbsolutePath();
        Object[] arguments = new Object[]{port, contextPath, webAppDirectory};
        return MessageFormat.format("{0} {1} \"{2}\"", arguments);
    }

    public String getVMArguments(ILaunchConfiguration configuration) throws CoreException {
        StringBuilder result = new StringBuilder();
        result.append(super.getVMArguments(configuration));
        result.append(VMARG_JETTY_HOME).append('\"').append(this.launch.getJettyHomePath()).append('\"');
        result.append(VMARG_DEVELOPMENT_MODE).append(this.launch.getLaunchConfig().getDevelopmentMode());
        return result.toString();
    }

    void initializeLaunch(ILaunch genericLaunch) {
        this.launch = new RWTLaunch(genericLaunch);
        this.launch.setPort(this.determinePort());
    }

    int determinePort() {
        RWTLaunchConfig launchConfig = this.launch.getLaunchConfig();
        int result = launchConfig.getUseManualPort() ? launchConfig.getPort() : SocketUtil.findFreePort();
        return result;
    }

    private String getContextPath() {
        RWTLaunchConfig config = this.launch.getLaunchConfig();
        String result = "/";
        if (config.getUseManualContextPath() && !config.getContextPath().equals("/")) {
            result = StringUtil.stripTrailingSlash(config.getContextPath());
        }
        return result;
    }
}

