/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler.jmx;

import org.eclipse.jetty.jmx.ObjectMBean;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractHandlerMBean
extends ObjectMBean {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractHandlerMBean.class);

    public AbstractHandlerMBean(Object managedObject) {
        super(managedObject);
    }

    public String getObjectContextBasis() {
        if (this._managed != null) {
            String basis = null;
            if (this._managed instanceof ContextHandler) {
                ContextHandler handler2 = (ContextHandler)this._managed;
                String context = this.getContextName(handler2);
                if (context == null) {
                    context = handler2.getDisplayName();
                }
                if (context != null) {
                    return context;
                }
            } else {
                Handler.Abstract handler;
                Server server;
                Object handler2 = this._managed;
                if (!(handler2 instanceof Handler.Abstract) || (server = (handler = (Handler.Abstract)handler2).getServer()) != null) {
                    // empty if block
                }
            }
            if (basis != null) {
                return basis;
            }
        }
        return super.getObjectContextBasis();
    }

    protected String getContextName(ContextHandler context) {
        String name = null;
        if (context.getContextPath() != null && context.getContextPath().length() > 0) {
            int idx = context.getContextPath().lastIndexOf(47);
            String string = name = idx < 0 ? context.getContextPath() : context.getContextPath().substring(++idx);
            if (name == null || name.length() == 0) {
                name = "ROOT";
            }
        }
        return name;
    }
}

